/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: slave_skip_errors.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS_CMD("slave_skip_errors",
	QStringList()<<"--slave-skip-errors=#", QObject::tr(
"When an error occurs on the slave, replication usually halts. This option "
"permits a list of error codes to ignore, and for which replication will "
"continue. This option should never be needed in normal use, and careless use "
"could lead to slaves that are out of sync with masters. Error codes are in "
"the format of the number from the slave error log. Using all as an option "
"permits the slave the keep replicating no matter what error it encounters, an "
"option you would never normally need in production and which could rapidly "
"lead to data inconsistencies. <b>MySQL Cluster NDB >= 7.2.6</b> permits the "
"<b>ddl_exists_errors</b> option, indicating error codes <b>1007</b>, "
"<b>1008</b>, <b>4050</b>, <b>1051</b>, <b>1054</b>, <b>1060</b>, <b>1061</b>, "
"<b>1068</b>, <b>1094</b> and <b>1146</b>"
));

/* EOF */
