/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: string_editor.cpp,v 1.1 2013/10/03 13:50:27 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "string_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_string.h"


StringEditor::StringEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(QString::null),
	saved_value(QString::null)
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	editor = new QLineEdit(this);
	connect(editor, SIGNAL(textChanged(const QString&)),
		this, SLOT(changed(const QString&)));
	layout->addWidget(editor);

	addDialog();
}

StringEditor::~StringEditor()
{

	delete editor;
	delete desc;
}


void
StringEditor::setTemplate(const TunableVariable *var)
{
	const TunableString	*tedit;

	FATAL(var->type() != TunableVariable::T_STRING);
	tedit = static_cast<const TunableString *>(var);
	desc->setText(var->description());

	setDefaultValue(tedit->value());
	setDefault();
	saved = FALSE;
}


void
StringEditor::setValue(const QString &val)
{

	if (!saved) {
		saved = TRUE;
		saved_value = val;
	}
	editor->setText(val);
}


void
StringEditor::changed(const QString &val)
{

	curr_value = val;
	setSaveEnabled(curr_value != saved_value);
}


void
StringEditor::setDefault()
{

	setValue(defaultValue());
}


void
StringEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, curr_value);
}

/* EOF */
