/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable.cpp,v 1.5 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "tunable.h"
#include "abstract_variable.h"


Tunable::Tunable()
	:BasicData(), mapped(NULL)
{

}

Tunable::Tunable(const QString &name)
	:BasicData(), mapped(NULL)
{

	setName(name);
}

Tunable::~Tunable()
{

}


void
Tunable::setName(const QString &n)
{
	QByteArray	tmp(n.toLower().toUtf8());

	p_name = n;
	mapped = AbstractVariable::lookup(tmp.constData());
}


void
Tunable::setValue(const QString &v)
{

	p_value = v;
}


QString
Tunable::name()const
{

	return (p_name);
}


QString
Tunable::prettyName()const
{
	QString	str(p_name.right(p_name.size() - 1));
	QChar	first(p_name[0]);

	return (QString("%1%2").arg(first.toUpper()).arg(str.toLower()));
}


QString
Tunable::value()const
{

	return (p_value);
}


AbstractVariable *
Tunable::parent()const
{

	return (mapped);
}

/* EOF */
