/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable.h,v 1.4 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNABLE_H__
#define __TUNABLE_H__

#include "gui.h"
#include "basic_data.h"

class Tunable;
class AbstractVariable;
typedef	QVector<Tunable *>		TunableVector;
typedef	QMap<QString, Tunable *>	TunableMap;

class Tunable:public BasicData
{
public:
	Tunable();
	Tunable(const QString&);
	~Tunable();

	void	setName(const QString&);
	void	setValue(const QString&);

	QString			name()const;
	QString			prettyName()const;
	QString			value()const;
	AbstractVariable	*parent()const;

private:
	QString			p_name;
	QString			p_value;
	AbstractVariable	*mapped;
};

#endif  /* __TUNABLE_H__ */

/* EOF */
