/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_enumeration.h,v 1.1 2013/09/30 12:10:24 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNABLE_ENUMERATION_H__
#define __TUNABLE_ENUMERATION_H__

#include "gui.h"
#include "tunable_variable.h"

typedef	QPair<QString, QString>	EnumItem;
typedef	QVector<EnumItem>	EnumVector;

class TunableEnumeration:public TunableVariable
{
public:
	TunableEnumeration(const QString&, const QString&);
	virtual ~TunableEnumeration();

	void	setValue(const QString&);
	void	setEnumeration(const EnumVector&);

	QString		value()const;
	EnumVector	vector()const;

	virtual AbstractEditor	*createEditor(QWidget *);

private:
	EnumVector	vect;
	QString		p_val;
};

#endif  /* __TUNABLE_ENUMERATION_H__ */

/* EOF */
