/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_real.cpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "tunable_real.h"
#include "real_editor.h"


TunableReal::TunableReal(const QString &name, const QString &desc)
	:TunableVariable(TunableVariable::T_REAL, name, desc)
{

	setRange(0.0, 0.0);
	setValue(0.0);
	setPrecision(3);
}

TunableReal::~TunableReal()
{
}


AbstractEditor *
TunableReal::createEditor(QWidget *parent)
{
	RealEditor	*ret;

	ret = new RealEditor(parent);
	FATAL(ret == NULL);

	return (ret);
}


void
TunableReal::setRange(qreal min, qreal max)
{

	p_min = min;
	p_max = max;
}


void
TunableReal::setValue(qreal val)
{

	p_val = val;
}


void
TunableReal::setPrecision(int p)
{

	p_prec = p;
}


qreal
TunableReal::maxValue()const
{

	return (p_max);
}


qreal
TunableReal::minValue()const
{

	return (p_min);
}


qreal
TunableReal::value()const
{

	return (p_val);
}


int
TunableReal::precision()const
{

	return (p_prec);
}

/* EOF */
