/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_real.h,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNABLE_REAL_H__
#define __TUNABLE_REAL_H__

#include "gui.h"
#include "tunable_variable.h"

class TunableReal:public TunableVariable
{
public:
	TunableReal(const QString&, const QString&);
	virtual ~TunableReal();

	void	setRange(qreal, qreal);
	void	setValue(qreal);
	void	setPrecision(int);

	qreal	maxValue()const;
	qreal	minValue()const;
	qreal	value()const;
	int	precision()const;

	virtual AbstractEditor	*createEditor(QWidget *);

private:
	qreal	p_min;
	qreal	p_max;
	qreal	p_val;
	int	p_prec;
};

#endif  /* __TUNABLE_REAL_H__ */

/* EOF */
