/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_set.cpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "tunable_set.h"
#include "set_editor.h"


TunableSet::TunableSet(const QString &name, const QString &desc)
	:TunableVariable(TunableVariable::T_SET, name, desc)
{

}

TunableSet::~TunableSet()
{
}


AbstractEditor *
TunableSet::createEditor(QWidget *parent)
{
	SetEditor	*ret;

	ret = new SetEditor(parent);
	FATAL(ret == NULL);

	return (ret);
}


void
TunableSet::setValue(const QString &val)
{

	p_val = val;
}


void
TunableSet::setEnumeration(const EnumVector &list)
{

	vect = list;
}


QString
TunableSet::value()const
{

	return (p_val);
}


EnumVector
TunableSet::vector()const
{

	return (vect);
}

/* EOF */
