/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_unsigned.cpp,v 1.1 2013/09/30 12:10:24 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "tunable_unsigned.h"
#include "unsigned_editor.h"


TunableUnsigned::TunableUnsigned(const QString &name, const QString &desc)
	:TunableVariable(TunableVariable::T_UINT, name, desc)
{

	setRange(0, 0);
	setValue(0);
}

TunableUnsigned::~TunableUnsigned()
{
}


AbstractEditor *
TunableUnsigned::createEditor(QWidget *parent)
{
	UnsignedEditor	*ret;

	ret = new UnsignedEditor(parent);
	FATAL(ret == NULL);

	return (ret);
}


void
TunableUnsigned::setRange(quint64 min, quint64 max)
{

	p_min = min;
	p_max = max;
}


void
TunableUnsigned::setValue(quint64 val)
{

	p_val = val;
}


quint64
TunableUnsigned::maxValue()const
{

	return (p_max);
}


quint64
TunableUnsigned::minValue()const
{

	return (p_min);
}


quint64
TunableUnsigned::value()const
{

	return (p_val);
}

/* EOF */
