/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tunable_variable.h,v 1.8 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNABLE_VARIABLE_H__
#define __TUNABLE_VARIABLE_H__

#include "gui.h"
#include "status_variable.h"
#include "abstract_editor.h"


class SqlConnection;

class TunableVariable:public StatusVariable
{
public:
	enum Type {
		T_INT,
		T_ENUM,
		T_UINT,
		T_BOOL,
		T_COMBO,
		T_STRING,
		T_SET,
		T_REAL,
		T_OPTIMIZER_SWITCH	/* special value */
	};

	TunableVariable(Type, const QString&, const QString&);
	virtual ~TunableVariable();

	Type	type()const;

	virtual AbstractEditor	*createEditor(QWidget *parent = NULL) = 0;

private:
	Type	p_type;
};

#endif  /* __TUNABLE_VARIABLE_H__ */
/* EOF */
