/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tuning.h,v 1.7 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNING_H__
#define __TUNING_H__

#include "gui.h"
#include "sql_service.h"

class TuningModel;
class TuningLegend;
class TuningFilter;

class Tuning:public QWidget, public SqlService
{
	Q_OBJECT
public:
	Tuning(ServerInfo *, QWidget *parent = NULL);
	virtual ~Tuning();

	virtual void	timeout();
	virtual void	privilegesChanged();

	virtual QString	tabName();

private:
	QVBoxLayout		*layout;
	QHBoxLayout		*hbox;
	QTableView		*view;
	TuningModel		*model;
	TuningFilter		*filter;
	TuningLegend		*legend;
	QDialogButtonBox	*dlg, *ctl;
	QPushButton		*v_info;
	QPushButton		*v_edit;
	QPushButton		*cmd_line;
	QPushButton		*cfg_file;

	void	unknownVariable(const QString&);

protected:
	virtual void	destroyIt();

public slots:
	void	deleteNow();

private slots:
	void	showInfo();
	void	editCurrent();
	void	showInfo(const QModelIndex&);
	void	testInfo(const QModelIndex&);
};

//-----------------------------------------------------------------------------

class TuningLegend:public QGroupBox
{
	Q_OBJECT
public:
	TuningLegend(QWidget *parent = NULL);
	~TuningLegend();

private:
	QVBoxLayout	*layout;
	QWidget		*unk;
	QWidget		*rw;
	QWidget		*ro;
};

//-----------------------------------------------------------------------------

class TuningFilter:public QGroupBox
{
	Q_OBJECT
public:
	TuningFilter(QWidget *parent = NULL);
	~TuningFilter();

	QString	filter()const;

private:
	QFormLayout	*layout;
	QLineEdit	*edit;
	QLCDNumber	*found;

public slots:
	void	setFound(int);

signals:
	void	filterChanged(const QString&);
};

#endif  /* __TUNING_H__ */

/* EOF */
