#-
# Copyright (c) 2013 by SilverSoft.Net
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# $Id: tuning.pro,v 1.15 2013/10/10 12:59:38 denis Exp $
#

#-
# Author: Denis Kozadaev (denis@silversoft.net)
#
# Please add file description here
#

TEMPLATE= lib
TARGET= tuning

SPECS= ../../../specs
include($$SPECS/install.pri)
include($$SPECS/plugin.pri)

CORE= ../../include
DEPENDPATH= status variable
INCLUDEPATH= $$CORE $$DEPENDPATH

S_HEADERS= status.hpp status/aborted_clients.hpp status/aborted_connects.hpp\
	status/access_denied_errors.hpp status/aria_block_size.hpp\
	status/aria_force_start_after_recovery_failures.hpp\
	status/aria_group_commit.hpp status/aria_group_commit_interval.hpp\
	status/aria_pagecache_blocks_not_flushed.hpp\
	status/aria_pagecache_blocks_unused.hpp\
	status/aria_pagecache_blocks_used.hpp\
	status/aria_pagecache_buffer_size.hpp\
	status/aria_pagecache_read_requests.hpp status/aria_pagecache_reads.hpp\
	status/aria_pagecache_write_requests.hpp\
	status/aria_pagecache_writes.hpp status/aria_transaction_log_syncs.hpp\
	status/aria_used_for_temp_tables.hpp status/back_log.hpp\
	status/basedir.hpp status/binlog_bytes_written.hpp\
	status/binlog_cache_disk_use.hpp status/binlog_cache_use.hpp\
	status/binlog_commits.hpp status/binlog_group_commits.hpp\
	status/binlog_optimize_thread_scheduling.hpp\
	status/binlog_snapshot_file.hpp status/binlog_snapshot_position.hpp\
	status/binlog_stmt_cache_disk_use.hpp status/binlog_stmt_cache_use.hpp\
	status/busy_time.hpp status/bytes_received.hpp status/bytes_sent.hpp\
	status/character_set_system.hpp status/character_sets_dir.hpp\
	status/com_admin_commands.hpp status/com_alter_db.hpp\
	status/com_alter_db_upgrade.hpp status/com_alter_event.hpp\
	status/com_alter_function.hpp status/com_alter_procedure.hpp\
	status/com_alter_server.hpp status/com_alter_table.hpp\
	status/com_alter_tablespace.hpp status/com_analyze.hpp\
	status/com_assign_to_keycache.hpp status/com_backup_table.hpp\
	status/com_begin.hpp status/com_binlog.hpp\
	status/com_call_procedure.hpp status/com_change_db.hpp\
	status/com_change_master.hpp status/com_check.hpp\
	status/com_checksum.hpp status/com_commit.hpp status/com_create_db.hpp\
	status/com_create_event.hpp status/com_create_function.hpp\
	status/com_create_index.hpp status/com_create_procedure.hpp\
	status/com_create_server.hpp status/com_create_table.hpp\
	status/com_create_trigger.hpp status/com_create_udf.hpp\
	status/com_create_user.hpp status/com_create_view.hpp\
	status/com_dealloc_sql.hpp status/com_delete.hpp\
	status/com_delete_multi.hpp status/com_do.hpp status/com_drop_db.hpp\
	status/com_drop_event.hpp status/com_drop_function.hpp\
	status/com_drop_index.hpp status/com_drop_procedure.hpp\
	status/com_drop_server.hpp status/com_drop_table.hpp\
	status/com_drop_trigger.hpp status/com_drop_user.hpp\
	status/com_drop_view.hpp status/com_empty_query.hpp\
	status/com_execute_sql.hpp status/com_flush.hpp status/com_grant.hpp\
	status/com_ha_close.hpp status/com_ha_open.hpp status/com_ha_read.hpp\
	status/com_help.hpp status/com_insert.hpp status/com_insert_select.hpp\
	status/com_install_plugin.hpp status/com_kill.hpp status/com_load.hpp\
	status/com_load_master_data.hpp status/com_load_master_table.hpp\
	status/com_lock_tables.hpp status/com_optimize.hpp\
	status/com_preload_keys.hpp status/com_prepare.hpp\
	status/com_prepare_sql.hpp status/com_purge.hpp\
	status/com_purge_before_date.hpp status/com_release_savepoint.hpp\
	status/com_rename_table.hpp status/com_rename_user.hpp\
	status/com_repair.hpp status/com_replace.hpp\
	status/com_replace_select.hpp status/com_reset.hpp\
	status/com_resignal.hpp status/com_revoke.hpp status/com_revoke_all.hpp\
	status/com_rollback.hpp status/com_rollback_to_savepoint.hpp\
	status/com_savepoint.hpp status/com_select.hpp\
	status/com_set_option.hpp status/com_show_authors.hpp\
	status/com_show_binlog_events.hpp status/com_show_binlogs.hpp\
	status/com_show_charsets.hpp status/com_show_client_statistics.hpp\
	status/com_show_collations.hpp status/com_show_contributors.hpp\
	status/com_show_create_db.hpp status/com_show_create_event.hpp\
	status/com_show_create_func.hpp status/com_show_create_proc.hpp\
	status/com_show_create_table.hpp status/com_show_create_trigger.hpp\
	status/com_show_databases.hpp status/com_show_engine_logs.hpp\
	status/com_show_engine_mutex.hpp status/com_show_engine_status.hpp\
	status/com_show_errors.hpp status/com_show_events.hpp\
	status/com_show_explain.hpp status/com_show_fields.hpp\
	status/com_show_function_code.hpp status/com_show_function_status.hpp\
	status/com_show_grants.hpp status/com_show_index_statistics.hpp\
	status/com_show_keys.hpp status/com_show_master_status.hpp\
	status/com_show_open_tables.hpp status/com_show_plugins.hpp\
	status/com_show_privileges.hpp status/com_show_procedure_code.hpp\
	status/com_show_procedure_status.hpp status/com_show_processlist.hpp\
	status/com_show_profile.hpp status/com_show_profiles.hpp\
	status/com_show_relaylog_events.hpp status/com_show_slave_hosts.hpp\
	status/com_show_slave_status.hpp status/com_show_status.hpp\
	status/com_show_storage_engines.hpp\
	status/com_show_table_statistics.hpp status/com_show_table_status.hpp\
	status/com_show_tables.hpp status/com_show_triggers.hpp\
	status/com_show_user_statistics.hpp status/com_show_variables.hpp\
	status/com_show_warnings.hpp status/com_signal.hpp\
	status/com_slave_start.hpp status/com_slave_stop.hpp\
	status/com_start_all_slaves.hpp status/com_start_slave.hpp\
	status/com_stmt_close.hpp status/com_stmt_execute.hpp\
	status/com_stmt_fetch.hpp status/com_stmt_prepare.hpp\
	status/com_stmt_reprepare.hpp status/com_stmt_reset.hpp\
	status/com_stmt_send_long_data.hpp status/com_stop_all_slaves.hpp\
	status/com_stop_slave.hpp status/com_truncate.hpp\
	status/com_uninstall_plugin.hpp status/com_unlock_tables.hpp\
	status/com_update.hpp status/com_update_multi.hpp\
	status/com_xa_commit.hpp status/com_xa_end.hpp\
	status/com_xa_prepare.hpp status/com_xa_recover.hpp\
	status/com_xa_rollback.hpp status/com_xa_start.hpp\
	status/compression.hpp status/connections.hpp status/cpu_time.hpp\
	status/created_tmp_disk_tables.hpp status/created_tmp_files.hpp\
	status/created_tmp_tables.hpp status/datadir.hpp\
	status/date_format.hpp status/datetime_format.hpp\
	status/debug_no_thread_alarm.hpp status/delayed_errors.hpp\
	status/delayed_insert_threads.hpp status/delayed_writes.hpp\
	status/empty_queries.hpp status/executed_events.hpp\
	status/executed_triggers.hpp status/extra_port.hpp\
	status/feature_dynamic_columns.hpp status/feature_fulltext.hpp\
	status/feature_gis.hpp status/feature_locale.hpp\
	status/feature_subquery.hpp status/feature_timezone.hpp\
	status/feature_trigger.hpp status/feature_xml.hpp\
	status/flush_commands.hpp status/ft_max_word_len.hpp\
	status/ft_min_word_len.hpp status/ft_query_expansion_limit.hpp\
	status/ft_stopword_file.hpp status/gtid_binlog_pos.hpp\
	status/gtid_current_pos.hpp status/handler_commit.hpp\
	status/handler_delete.hpp status/handler_discover.hpp\
	status/handler_external_lock.hpp status/handler_icp_attempts.hpp\
	status/handler_icp_match.hpp status/handler_mrr_init.hpp\
	status/handler_mrr_key_refills.hpp\
	status/handler_mrr_rowid_refills.hpp\
	status/handler_prepare.hpp status/handler_read_first.hpp\
	status/handler_read_key.hpp status/handler_read_last.hpp\
	status/handler_read_next.hpp status/handler_read_prev.hpp\
	status/handler_read_rnd.hpp status/handler_read_rnd_deleted.hpp\
	status/handler_read_rnd_next.hpp status/handler_rollback.hpp\
	status/handler_savepoint.hpp status/handler_savepoint_rollback.hpp\
	status/handler_tmp_update.hpp status/handler_tmp_write.hpp\
	status/handler_update.hpp status/handler_write.hpp\
	status/have_compress.hpp status/have_crypt.hpp status/have_csv.hpp\
	status/have_dynamic_loading.hpp status/have_geometry.hpp\
	status/have_innodb.hpp status/have_ndbcluster.hpp\
	status/have_openssl.hpp status/have_partitioning.hpp\
	status/have_profiling.hpp status/have_query_cache.hpp\
	status/have_rtree_keys.hpp status/have_ssl.hpp status/have_symlink.hpp\
	status/hostname.hpp status/ignore_builtin_innodb.hpp\
	status/ignore_db_dirs.hpp status/init_file.hpp\
	status/innodb_adaptive_hash_cells.hpp\
	status/innodb_adaptive_hash_hash_searches.hpp\
	status/innodb_adaptive_hash_heap_buffers.hpp\
	status/innodb_adaptive_hash_index_partitions.hpp\
	status/innodb_adaptive_hash_non_hash_searches.hpp\
	status/innodb_additional_mem_pool_size.hpp\
	status/innodb_autoinc_lock_mode.hpp\
	status/innodb_available_undo_logs.hpp\
	status/innodb_background_log_sync.hpp\
	status/innodb_blocking_buffer_pool_restore.hpp\
	status/innodb_buffer_pool_bytes_data.hpp\
	status/innodb_buffer_pool_bytes_dirty.hpp\
	status/innodb_buffer_pool_dump_status.hpp\
	status/innodb_buffer_pool_instances.hpp\
	status/innodb_buffer_pool_load_at_startup.hpp\
	status/innodb_buffer_pool_load_status.hpp\
	status/innodb_buffer_pool_pages_data.hpp\
	status/innodb_buffer_pool_pages_dirty.hpp\
	status/innodb_buffer_pool_pages_flushed.hpp\
	status/innodb_buffer_pool_pages_free.hpp\
	status/innodb_buffer_pool_pages_lru_flushed.hpp\
	status/innodb_buffer_pool_pages_made_not_young.hpp\
	status/innodb_buffer_pool_pages_made_young.hpp\
	status/innodb_buffer_pool_pages_misc.hpp\
	status/innodb_buffer_pool_pages_old.hpp\
	status/innodb_buffer_pool_pages_total.hpp\
	status/innodb_buffer_pool_populate.hpp\
	status/innodb_buffer_pool_read_ahead.hpp\
	status/innodb_buffer_pool_read_ahead_evicted.hpp\
	status/innodb_buffer_pool_read_ahead_rnd.hpp\
	status/innodb_buffer_pool_read_requests.hpp\
	status/innodb_buffer_pool_reads.hpp\
	status/innodb_buffer_pool_shm_checksum.hpp\
	status/innodb_buffer_pool_shm_key.hpp\
	status/innodb_buffer_pool_size.hpp\
	status/innodb_buffer_pool_wait_free.hpp\
	status/innodb_buffer_pool_write_requests.hpp\
	status/innodb_checkpoint_age.hpp status/innodb_checkpoint_max_age.hpp\
	status/innodb_checkpoint_target_age.hpp status/innodb_checksums.hpp\
	status/innodb_current_row_locks.hpp status/innodb_data_file_path.hpp\
	status/innodb_data_fsyncs.hpp status/innodb_data_home_dir.hpp\
	status/innodb_data_pending_fsyncs.hpp\
	status/innodb_data_pending_reads.hpp\
	status/innodb_data_pending_writes.hpp status/innodb_data_read.hpp\
	status/innodb_data_reads.hpp status/innodb_data_writes.hpp\
	status/innodb_data_written.hpp status/innodb_dblwr_pages_written.hpp\
	status/innodb_dblwr_writes.hpp status/innodb_deadlocks.hpp\
	status/innodb_dict_tables.hpp status/innodb_doublewrite.hpp\
	status/innodb_doublewrite_file.hpp status/innodb_extra_rsegments.hpp\
	status/innodb_extra_undoslots.hpp status/innodb_fast_checksum.hpp\
	status/innodb_file_format_check.hpp status/innodb_flush_method.hpp\
	status/innodb_force_load_corrupted.hpp\
	status/innodb_force_recovery.hpp status/innodb_ft_cache_size.hpp\
	status/innodb_ft_max_token_size.hpp\
	status/innodb_ft_min_token_size.hpp\
	status/innodb_ft_sort_pll_degree.hpp\
	status/innodb_have_atomic_builtins.hpp\
	status/innodb_history_list_length.hpp\
	status/innodb_ibuf_discarded_delete_marks.hpp\
	status/innodb_ibuf_discarded_deletes.hpp\
	status/innodb_ibuf_discarded_inserts.hpp\
	status/innodb_ibuf_free_list.hpp status/innodb_ibuf_max_size.hpp\
	status/innodb_ibuf_merged_delete_marks.hpp\
	status/innodb_ibuf_merged_deletes.hpp\
	status/innodb_ibuf_merged_inserts.hpp status/innodb_ibuf_merges.hpp\
	status/innodb_ibuf_segment_size.hpp status/innodb_ibuf_size.hpp\
	status/innodb_log_block_size.hpp status/innodb_log_buffer_size.hpp\
	status/innodb_log_file_size.hpp status/innodb_log_files_in_group.hpp\
	status/innodb_log_group_home_dir.hpp status/innodb_log_waits.hpp\
	status/innodb_log_write_requests.hpp status/innodb_log_writes.hpp\
	status/innodb_lsn_current.hpp status/innodb_lsn_flushed.hpp\
	status/innodb_lsn_last_checkpoint.hpp\
	status/innodb_master_thread_10_second_loops.hpp\
	status/innodb_master_thread_1_second_loops.hpp\
	status/innodb_master_thread_background_loops.hpp\
	status/innodb_master_thread_main_flush_loops.hpp\
	status/innodb_master_thread_sleeps.hpp\
	status/innodb_max_dirty_pages_pct.hpp status/innodb_max_trx_id.hpp\
	status/innodb_mem_adaptive_hash.hpp status/innodb_mem_dictionary.hpp\
	status/innodb_mem_total.hpp status/innodb_mirrored_log_groups.hpp\
	status/innodb_mutex_os_waits.hpp status/innodb_mutex_spin_rounds.hpp\
	status/innodb_mutex_spin_waits.hpp status/innodb_num_open_files.hpp\
	status/innodb_oldest_view_low_limit_trx_id.hpp\
	status/innodb_open_files.hpp status/innodb_os_log_fsyncs.hpp\
	status/innodb_os_log_pending_fsyncs.hpp\
	status/innodb_os_log_pending_writes.hpp\
	status/innodb_os_log_written.hpp status/innodb_page_size.hpp\
	status/innodb_pages_created.hpp status/innodb_pages_read.hpp\
	status/innodb_pages_written.hpp status/innodb_purge_batch_size.hpp\
	status/innodb_purge_threads.hpp status/innodb_purge_trx_id.hpp\
	status/innodb_purge_undo_no.hpp status/innodb_read_io_threads.hpp\
	status/innodb_recovery_stats.hpp\
	status/innodb_recovery_update_relay_log.hpp\
	status/innodb_rollback_on_timeout.hpp\
	status/innodb_row_lock_current_waits.hpp\
	status/innodb_row_lock_numbers.hpp status/innodb_row_lock_time.hpp\
	status/innodb_row_lock_time_avg.hpp\
	status/innodb_row_lock_time_max.hpp\
	status/innodb_row_lock_time_waits.hpp status/innodb_row_lock_waits.hpp\
	status/innodb_rows_deleted.hpp status/innodb_rows_inserted.hpp\
	status/innodb_rows_read.hpp status/innodb_rows_updated.hpp\
	status/innodb_s_lock_os_waits.hpp status/innodb_s_lock_spin_rounds.hpp\
	status/innodb_s_lock_spin_waits.hpp status/innodb_sort_buffer_size.hpp\
	status/innodb_sync_array_size.hpp\
	status/innodb_thread_concurrency_timer_based.hpp\
	status/innodb_track_changed_pages.hpp\
	status/innodb_truncated_status_writes.hpp\
	status/innodb_undo_directory.hpp status/innodb_undo_logs.hpp\
	status/innodb_undo_tablespaces.hpp status/innodb_use_atomic_writes.hpp\
	status/innodb_use_fallocate.hpp status/innodb_use_native_aio.hpp\
	status/innodb_use_purge_thread.hpp status/innodb_use_sys_malloc.hpp\
	status/innodb_use_sys_stats_table.hpp status/innodb_version.hpp\
	status/innodb_write_io_threads.hpp status/innodb_x_lock_os_waits.hpp\
	status/innodb_x_lock_spin_rounds.hpp\
	status/innodb_x_lock_spin_waits.hpp status/key_blocks_not_flushed.hpp\
	status/key_blocks_unused.hpp status/key_blocks_used.hpp\
	status/key_blocks_warm.hpp status/key_read_requests.hpp\
	status/key_reads.hpp status/key_write_requests.hpp\
	status/key_writes.hpp status/language.hpp\
	status/large_files_support.hpp status/large_page_size.hpp\
	status/large_pages.hpp status/last_query_cost.hpp\
	status/lc_messages_dir.hpp status/license.hpp\
	status/locked_in_memory.hpp status/log_bin.hpp status/log_error.hpp\
	status/log_slave_updates.hpp status/lower_case_file_system.hpp\
	status/lower_case_table_names.hpp status/max_long_data_size.hpp\
	status/max_used_connections.hpp status/max_write_lock_count.hpp\
	status/memory_used.hpp status/metadata_locks_cache_size.hpp\
	status/myisam_block_size.hpp status/myisam_recover_options.hpp\
	status/not_flushed_delayed_rows.hpp status/old.hpp\
	status/open_files.hpp status/open_files_limit.hpp\
	status/open_streams.hpp status/open_table_definitions.hpp\
	status/open_tables.hpp status/opened_files.hpp\
	status/opened_plugin_libraries.hpp status/opened_table_definitions.hpp\
	status/opened_tables.hpp status/opened_views.hpp\
	status/performance_schema.hpp\
	status/performance_schema_accounts_lost.hpp\
	status/performance_schema_accounts_size.hpp\
	status/performance_schema_cond_classes_lost.hpp\
	status/performance_schema_cond_instances_lost.hpp\
	status/performance_schema_digest_lost.hpp\
	status/performance_schema_digests_size.hpp\
	status/performance_schema_events_stages_history_long_size.hpp\
	status/performance_schema_events_stages_history_size.hpp\
	status/performance_schema_events_statements_history_long_size.hpp\
	status/performance_schema_events_statements_history_size.hpp\
	status/performance_schema_events_waits_history_long_size.hpp\
	status/performance_schema_events_waits_history_size.hpp\
	status/performance_schema_file_classes_lost.hpp\
	status/performance_schema_file_handles_lost.hpp\
	status/performance_schema_file_instances_lost.hpp\
	status/performance_schema_hosts_lost.hpp\
	status/performance_schema_hosts_size.hpp\
	status/performance_schema_locker_lost.hpp\
	status/performance_schema_max_cond_classes.hpp\
	status/performance_schema_max_cond_instances.hpp\
	status/performance_schema_max_file_classes.hpp\
	status/performance_schema_max_file_handles.hpp\
	status/performance_schema_max_file_instances.hpp\
	status/performance_schema_max_mutex_classes.hpp\
	status/performance_schema_max_mutex_instances.hpp\
	status/performance_schema_max_rwlock_classes.hpp\
	status/performance_schema_max_rwlock_instances.hpp\
	status/performance_schema_max_socket_classes.hpp\
	status/performance_schema_max_socket_instances.hpp\
	status/performance_schema_max_stage_classes.hpp\
	status/performance_schema_max_statement_classes.hpp\
	status/performance_schema_max_table_handles.hpp\
	status/performance_schema_max_table_instances.hpp\
	status/performance_schema_max_thread_classes.hpp\
	status/performance_schema_max_thread_instances.hpp\
	status/performance_schema_mutex_classes_lost.hpp\
	status/performance_schema_mutex_instances_lost.hpp\
	status/performance_schema_rwlock_classes_lost.hpp\
	status/performance_schema_rwlock_instances_lost.hpp\
	status/performance_schema_setup_actors_size.hpp\
	status/performance_schema_setup_objects_size.hpp\
	status/performance_schema_socket_classes_lost.hpp\
	status/performance_schema_socket_instances_lost.hpp\
	status/performance_schema_stage_classes_lost.hpp\
	status/performance_schema_statement_classes_lost.hpp\
	status/performance_schema_table_handles_lost.hpp\
	status/performance_schema_table_instances_lost.hpp\
	status/performance_schema_thread_classes_lost.hpp\
	status/performance_schema_thread_instances_lost.hpp\
	status/performance_schema_users_lost.hpp\
	status/performance_schema_users_size.hpp status/pid_file.hpp\
	status/plugin_dir.hpp status/plugin_maturity.hpp status/port.hpp\
	status/prepared_stmt_count.hpp status/protocol_version.hpp\
	status/qcache_free_blocks.hpp status/qcache_free_memory.hpp\
	status/qcache_hits.hpp status/qcache_inserts.hpp\
	status/qcache_lowmem_prunes.hpp status/qcache_not_cached.hpp\
	status/qcache_queries_in_cache.hpp status/qcache_total_blocks.hpp\
	status/queries.hpp status/questions.hpp status/relay_log.hpp\
	status/relay_log_index.hpp status/relay_log_info_file.hpp\
	status/relay_log_space_limit.hpp\
	status/replicate_annotate_row_events.hpp status/report_host.hpp\
	status/report_password.hpp status/report_port.hpp\
	status/report_user.hpp status/rows_read.hpp status/rows_sent.hpp\
	status/rows_tmp_read.hpp status/rpl_recovery_rank.hpp\
	status/rpl_status.hpp status/secure_file_priv.hpp\
	status/select_full_join.hpp status/select_full_range_join.hpp\
	status/select_range.hpp status/select_range_check.hpp\
	status/select_scan.hpp status/shared_memory.hpp\
	status/shared_memory_base_name.hpp status/skip_external_locking.hpp\
	status/skip_name_resolve.hpp status/skip_networking.hpp\
	status/skip_show_database.hpp status/slave_heartbeat_period.hpp\
	status/slave_load_tmpdir.hpp status/slave_open_temp_tables.hpp\
	status/slave_received_heartbeats.hpp\
	status/slave_retried_transactions.hpp status/slave_running.hpp\
	status/slave_skip_errors.hpp status/slave_type_conversions.hpp\
	status/slow_launch_threads.hpp status/slow_queries.hpp\
	status/socket.hpp status/sort_merge_passes.hpp status/sort_range.hpp\
	status/sort_rows.hpp status/sort_scan.hpp status/sphinx_error.hpp\
	status/ssl_accept_renegotiates.hpp status/ssl_accepts.hpp\
	status/ssl_ca.hpp status/ssl_callback_cache_hits.hpp\
	status/ssl_capath.hpp status/ssl_cert.hpp status/ssl_cipher.hpp\
	status/ssl_cipher_list.hpp status/ssl_client_connects.hpp\
	status/ssl_connect_renegotiates.hpp status/ssl_crl.hpp\
	status/ssl_crlpath.hpp status/ssl_ctx_verify_depth.hpp\
	status/ssl_ctx_verify_mode.hpp status/ssl_default_timeout.hpp\
	status/ssl_finished_accepts.hpp status/ssl_finished_connects.hpp\
	status/ssl_key.hpp status/ssl_server_not_after.hpp\
	status/ssl_server_not_before.hpp status/ssl_session_cache_hits.hpp\
	status/ssl_session_cache_misses.hpp status/ssl_session_cache_mode.hpp\
	status/ssl_session_cache_overflows.hpp\
	status/ssl_session_cache_size.hpp\
	status/ssl_session_cache_timeouts.hpp status/ssl_sessions_reused.hpp\
	status/ssl_used_session_cache_entries.hpp status/ssl_verify_depth.hpp\
	status/ssl_verify_mode.hpp status/ssl_version.hpp\
	status/storage_engine.hpp status/subquery_cache_hit.hpp\
	status/subquery_cache_miss.hpp status/syncs.hpp\
	status/system_time_zone.hpp status/table_locks_immediate.hpp\
	status/table_locks_waited.hpp status/tc_log_max_pages_used.hpp\
	status/tc_log_page_size.hpp status/tc_log_page_waits.hpp\
	status/thread_concurrency.hpp status/thread_handling.hpp\
	status/thread_pool_algorithm.hpp status/thread_pool_size.hpp\
	status/thread_stack.hpp status/threadpool_idle_threads.hpp\
	status/threadpool_threads.hpp status/threads_cached.hpp\
	status/threads_connected.hpp status/threads_created.hpp\
	status/threads_running.hpp status/time_format.hpp status/tmpdir.hpp\
	status/uptime.hpp status/uptime_since_flush_status.hpp\
	status/version.hpp status/version_comment.hpp\
	status/version_compile_machine.hpp status/version_compile_os.hpp

V_HEADERS= variable.hpp variable/aria_checkpoint_interval.hpp\
	variable/aria_checkpoint_log_activity.hpp\
	variable/aria_log_file_size.hpp variable/aria_log_purge_type.hpp\
	variable/aria_max_sort_file_size.hpp variable/aria_page_checksum.hpp\
	variable/aria_pagecache_age_threshold.hpp\
	variable/aria_pagecache_division_limit.hpp variable/aria_recover.hpp\
	variable/aria_repair_threads.hpp variable/aria_sort_buffer_size.hpp\
	variable/aria_stats_method.hpp variable/aria_sync_log_dir.hpp\
	variable/auto_increment_increment.hpp\
	variable/auto_increment_offset.hpp variable/autocommit.hpp\
	variable/automatic_sp_privileges.hpp variable/big_tables.hpp\
	variable/binlog_annotate_row_events.hpp variable/binlog_cache_size.hpp\
	variable/binlog_checksum.hpp\
	variable/binlog_direct_non_transactional_updates.hpp\
	variable/binlog_format.hpp variable/binlog_stmt_cache_size.hpp\
	variable/bulk_insert_buffer_size.hpp variable/character_set_client.hpp\
	variable/character_set_connection.hpp\
	variable/character_set_database.hpp\
	variable/character_set_filesystem.hpp\
	variable/character_set_results.hpp variable/character_set_server.hpp\
	variable/collation_connection.hpp variable/collation_database.hpp\
	variable/collation_server.hpp variable/completion_type.hpp\
	variable/concurrent_insert.hpp variable/connect_timeout.hpp\
	variable/deadlock_search_depth_long.hpp\
	variable/deadlock_search_depth_short.hpp\
	variable/deadlock_timeout_long.hpp variable/deadlock_timeout_short.hpp\
	variable/debug.hpp variable/default_storage_engine.hpp\
	variable/default_week_format.hpp variable/delay_key_write.hpp\
	variable/delayed_insert_limit.hpp variable/delayed_insert_timeout.hpp\
	variable/delayed_queue_size.hpp variable/div_precision_increment.hpp\
	variable/engine_condition_pushdown.hpp variable/event_scheduler.hpp\
	variable/expensive_subquery_limit.hpp variable/expire_logs_days.hpp\
	variable/extra_max_connections.hpp variable/flush.hpp\
	variable/flush_time.hpp variable/foreign_key_checks.hpp\
	variable/ft_boolean_syntax.hpp variable/general_log.hpp\
	variable/general_log_file.hpp variable/group_concat_max_len.hpp\
	variable/gtid_domain_id.hpp variable/gtid_slave_pos.hpp\
	variable/gtid_strict_mode.hpp variable/histogram_size.hpp\
	variable/histogram_type.hpp variable/init_connect.hpp\
	variable/init_slave.hpp variable/innodb_adaptive_checkpoint.hpp\
	variable/innodb_adaptive_flushing.hpp\
	variable/innodb_adaptive_flushing_method.hpp\
	variable/innodb_adaptive_hash_index.hpp\
	variable/innodb_adaptive_max_sleep_delay.hpp\
	variable/innodb_analyze_is_persistent.hpp\
	variable/innodb_autoextend_increment.hpp\
	variable/innodb_buffer_pool_dump_at_shutdown.hpp\
	variable/innodb_buffer_pool_dump_now.hpp\
	variable/innodb_buffer_pool_filename.hpp\
	variable/innodb_buffer_pool_load_abort.hpp\
	variable/innodb_buffer_pool_load_now.hpp\
	variable/innodb_buffer_pool_restore_at_startup.hpp\
	variable/innodb_change_buffer_max_size.hpp\
	variable/innodb_change_buffering.hpp\
	variable/innodb_checkpoint_age_target.hpp\
	variable/innodb_checksum_algorithm.hpp\
	variable/innodb_commit_concurrency.hpp\
	variable/innodb_concurrency_tickets.hpp\
	variable/innodb_corrupt_table_action.hpp\
	variable/innodb_dict_size_limit.hpp\
	variable/innodb_disable_sort_file_cache.hpp\
	variable/innodb_enable_unsafe_group_commit.hpp\
	variable/innodb_fake_changes.hpp variable/innodb_fast_shutdown.hpp\
	variable/innodb_file_format.hpp variable/innodb_file_format_max.hpp\
	variable/innodb_file_per_table.hpp\
	variable/innodb_flush_log_at_trx_commit.hpp\
	variable/innodb_flush_neighbor_pages.hpp\
	variable/innodb_flush_neighbors.hpp variable/innodb_ft_aux_table.hpp\
	variable/innodb_ft_enable_diag_print.hpp\
	variable/innodb_ft_enable_stopword.hpp\
	variable/innodb_ft_num_word_optimize.hpp\
	variable/innodb_ft_server_stopword_table.hpp\
	variable/innodb_ft_user_stopword_table.hpp\
	variable/innodb_ibuf_accel_rate.hpp\
	variable/innodb_ibuf_active_contract.hpp\
	variable/innodb_import_table_from_xtrabackup.hpp\
	variable/innodb_io_capacity.hpp\
	variable/innodb_kill_idle_transaction.hpp\
	variable/innodb_large_prefix.hpp variable/innodb_lazy_drop_table.hpp\
	variable/innodb_lock_wait_timeout.hpp\
	variable/innodb_locking_fake_changes.hpp\
	variable/innodb_locks_unsafe_for_binlog.hpp\
	variable/innodb_lru_scan_depth.hpp\
	variable/innodb_max_bitmap_file_size.hpp\
	variable/innodb_max_changed_pages.hpp\
	variable/innodb_max_purge_lag.hpp\
	variable/innodb_max_purge_lag_delay.hpp\
	variable/innodb_merge_sort_block_size.hpp\
	variable/innodb_monitor_disable.hpp variable/innodb_monitor_enable.hpp\
	variable/innodb_monitor_reset.hpp\
	variable/innodb_monitor_reset_all.hpp\
	variable/innodb_old_blocks_pct.hpp variable/innodb_old_blocks_time.hpp\
	variable/innodb_optimize_fulltext_only.hpp\
	variable/innodb_print_all_deadlocks.hpp\
	variable/innodb_random_read_ahead.hpp variable/innodb_read_ahead.hpp\
	variable/innodb_read_ahead_threshold.hpp\
	variable/innodb_replication_delay.hpp\
	variable/innodb_rollback_segments.hpp\
	variable/innodb_show_locks_held.hpp\
	variable/innodb_show_verbose_locks.hpp\
	variable/innodb_spin_wait_delay.hpp\
	variable/innodb_stats_auto_update.hpp variable/innodb_stats_method.hpp\
	variable/innodb_stats_on_metadata.hpp\
	variable/innodb_stats_persistent_sample_pages.hpp\
	variable/innodb_stats_sample_pages.hpp\
	variable/innodb_stats_transient_sample_pages.hpp\
	variable/innodb_stats_update_need_lock.hpp\
	variable/innodb_strict_mode.hpp variable/innodb_support_xa.hpp\
	variable/innodb_sync_spin_loops.hpp variable/innodb_table_locks.hpp\
	variable/innodb_thread_concurrency.hpp\
	variable/innodb_thread_sleep_delay.hpp\
	variable/innodb_use_global_flush_log_at_trx_commit.hpp\
	variable/interactive_timeout.hpp variable/join_buffer_size.hpp\
	variable/join_buffer_space_limit.hpp variable/join_cache_level.hpp\
	variable/keep_files_on_create.hpp variable/key_buffer_size.hpp\
	variable/key_cache_age_threshold.hpp variable/key_cache_block_size.hpp\
	variable/key_cache_division_limit.hpp variable/key_cache_segments.hpp\
	variable/lc_messages.hpp variable/lc_time_names.hpp\
	variable/local_infile.hpp variable/lock_wait_timeout.hpp\
	variable/log.hpp variable/log_bin_trust_function_creators.hpp\
	variable/log_output.hpp variable/log_queries_not_using_indexes.hpp\
	variable/log_slow_filter.hpp variable/log_slow_queries.hpp\
	variable/log_slow_rate_limit.hpp variable/log_slow_verbosity.hpp\
	variable/log_warnings.hpp variable/long_query_time.hpp\
	variable/low_priority_updates.hpp variable/master_verify_checksum.hpp\
	variable/max_allowed_packet.hpp variable/max_binlog_cache_size.hpp\
	variable/max_binlog_size.hpp variable/max_binlog_stmt_cache_size.hpp\
	variable/max_connect_errors.hpp variable/max_connections.hpp\
	variable/max_delayed_threads.hpp variable/max_error_count.hpp\
	variable/max_heap_table_size.hpp\
	variable/max_insert_delayed_threads.hpp variable/max_join_size.hpp\
	variable/max_length_for_sort_data.hpp\
	variable/max_prepared_stmt_count.hpp variable/max_relay_log_size.hpp\
	variable/max_seeks_for_key.hpp variable/max_sort_length.hpp\
	variable/max_sp_recursion_depth.hpp variable/max_tmp_tables.hpp\
	variable/max_user_connections.hpp variable/min_examined_row_limit.hpp\
	variable/mrr_buffer_size.hpp variable/multi_range_count.hpp\
	variable/myisam_data_pointer_size.hpp\
	variable/myisam_max_sort_file_size.hpp variable/myisam_mmap_size.hpp\
	variable/myisam_repair_threads.hpp\
	variable/myisam_sort_buffer_size.hpp variable/myisam_stats_method.hpp\
	variable/myisam_use_mmap.hpp variable/net_buffer_length.hpp\
	variable/net_read_timeout.hpp variable/net_retry_count.hpp\
	variable/net_write_timeout.hpp variable/old_alter_table.hpp\
	variable/old_passwords.hpp variable/optimizer_prune_level.hpp\
	variable/optimizer_search_depth.hpp\
	variable/optimizer_selectivity_sampling_limit.hpp\
	variable/optimizer_switch.hpp\
	variable/optimizer_use_condition_selectivity.hpp\
	variable/preload_buffer_size.hpp variable/profiling.hpp\
	variable/profiling_history_size.hpp variable/progress_report_time.hpp\
	variable/query_alloc_block_size.hpp variable/query_cache_limit.hpp\
	variable/query_cache_min_res_unit.hpp variable/query_cache_size.hpp\
	variable/query_cache_strip_comments.hpp variable/query_cache_type.hpp\
	variable/query_cache_wlock_invalidate.hpp\
	variable/query_prealloc_size.hpp variable/range_alloc_block_size.hpp\
	variable/read_buffer_size.hpp variable/read_only.hpp\
	variable/read_rnd_buffer_size.hpp variable/relay_log_purge.hpp\
	variable/relay_log_recovery.hpp variable/replicate_do_db.hpp\
	variable/replicate_do_table.hpp\
	variable/replicate_events_marked_for_skip.hpp\
	variable/replicate_ignore_db.hpp variable/replicate_ignore_table.hpp\
	variable/replicate_wild_do_table.hpp\
	variable/replicate_wild_ignore_table.hpp\
	variable/rowid_merge_buff_size.hpp variable/safe_show_database.hpp\
	variable/secure_auth.hpp variable/server_id.hpp\
	variable/slave_compressed_protocol.hpp variable/slave_exec_mode.hpp\
	variable/slave_max_allowed_packet.hpp variable/slave_net_timeout.hpp\
	variable/slave_sql_verify_checksum.hpp\
	variable/slave_transaction_retries.hpp variable/slow_launch_time.hpp\
	variable/slow_query_log.hpp variable/slow_query_log_file.hpp\
	variable/sort_buffer_size.hpp variable/sql_auto_is_null.hpp\
	variable/sql_big_selects.hpp variable/sql_big_tables.hpp\
	variable/sql_buffer_result.hpp variable/sql_log_bin.hpp\
	variable/sql_log_off.hpp variable/sql_low_priority_updates.hpp\
	variable/sql_max_join_size.hpp variable/sql_mode.hpp\
	variable/sql_notes.hpp variable/sql_quote_show_create.hpp\
	variable/sql_safe_updates.hpp variable/sql_select_limit.hpp\
	variable/sql_slave_skip_counter.hpp variable/sql_warnings.hpp\
	variable/stored_program_cache.hpp variable/sync_binlog.hpp\
	variable/sync_frm.hpp variable/sync_master_info.hpp\
	variable/sync_relay_log.hpp variable/sync_relay_log_info.hpp\
	variable/table_definition_cache.hpp\
	variable/table_lock_wait_timeout.hpp variable/table_open_cache.hpp\
	variable/thread_cache_size.hpp\
	variable/thread_pool_high_priority_connection.hpp\
	variable/thread_pool_idle_timeout.hpp\
	variable/thread_pool_max_threads.hpp\
	variable/thread_pool_max_unused_threads.hpp\
	variable/thread_pool_min_threads.hpp\
	variable/thread_pool_oversubscribe.hpp\
	variable/thread_pool_prio_kickup_timer.hpp\
	variable/thread_pool_stall_limit.hpp variable/time_zone.hpp\
	variable/timed_mutexes.hpp variable/tmp_table_size.hpp\
	variable/transaction_alloc_block_size.hpp\
	variable/transaction_prealloc_size.hpp variable/tx_isolation.hpp\
	variable/tx_read_only.hpp variable/unique_checks.hpp\
	variable/updatable_views_with_limit.hpp variable/use_stat_tables.hpp\
	variable/userstat.hpp variable/wait_timeout.hpp

HEADERS= $$CORE/gui.h $$CORE/server_info.h $$S_HEADERS $$V_HEADERS\
	plg_tuning.h tuning.h tuning_model.h tunable.h informer.h\
	abstract_variable.h status_variable.h\
	abstract_editor.h integer_editor.h enumeration_editor.h\
	unsigned_editor.h boolean_editor.h combo_editor.h\
	string_editor.h set_editor.h real_editor.h\
	optimizer_switch_editor.h\
	tunable_variable.h tunable_integer.h tunable_enumeration.h\
	tunable_unsigned.h tunable_boolean.h tunable_combo.h\
	tunable_string.h tunable_set.h tunable_real.h\
	tunable_optimizer_switch.h

SOURCES= plg_tuning.cpp tuning.cpp tuning_model.cpp tunable.cpp informer.cpp\
	abstract_variable.cpp status_variable.cpp\
	abstract_editor.cpp integer_editor.cpp enumeration_editor.cpp\
	unsigned_editor.cpp boolean_editor.cpp combo_editor.cpp\
	string_editor.cpp set_editor.cpp real_editor.cpp\
	optimizer_switch_editor.cpp\
	tunable_variable.cpp tunable_integer.cpp tunable_enumeration.cpp\
	tunable_unsigned.cpp tunable_boolean.cpp tunable_combo.cpp\
	tunable_string.cpp tunable_set.cpp tunable_real.cpp\
	tunable_optimizer_switch.cpp

LOCALE_FILE=$$TARGET
include($$SPECS/config.pri)

TRANSLATIONS= $${LOCALE_FILE}.ts
RESOURCES= $${TARGET}.qrc

# EOF
