/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tuning_model.h,v 1.5 2013/10/08 14:38:35 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __TUNING_MODEL_H__
#define __TUNING_MODEL_H__

#include "gui.h"
#include "tunable.h"


class SqlConnection;
class SqlQuery;

class TuningModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	TuningModel(SqlConnection *, QObject *parent = NULL);
	virtual ~TuningModel();

	void	timeout();
	void	setDefault(const QString&, QWidget *);

	Tunable	*tunable(const QModelIndex&)const;
	Tunable	*tunable(int)const;

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	QString		filter;
	TunableVector	vect;
	TunableMap	map;
	SqlQuery	*q_status;
	SqlQuery	*q_variable;
	unsigned long	changes;

	void	loadQuery(SqlQuery *);
	void	markAll();
	void	deleteMarked();
	void	copyData(Tunable&, SqlQuery *);
	void	updateData(Tunable *, const Tunable&);
	void	changed(int&, int, Tunable *);

	int		findPosition(const QString&);
	QVariant	displayData(const Tunable *, int)const;
	QVariant	backgroundData(const Tunable *)const;

public slots:
	void	setFilter(const QString&);

private slots:
	void	reloadStatus();
	void	reloadVariables();

signals:
	void	modelChanged();
	void	found(int);
};

#endif  /* __TUNING_MODEL_H__ */

/* EOF */
