/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: variable.hpp,v 1.12 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */


static EnumVector
charsets_all(int type)
{
	EnumVector	ret;

	ret<<EnumItem("armscii8", QObject::tr("ARMSCII-8 Armenian (armscii8)"))
	<<EnumItem("ascii", QObject::tr("US ASCII (ascii)"))
	<<EnumItem("big5", QObject::tr("Big5 Traditional Chinese (big5)"))
	<<EnumItem("binary", QObject::tr("Binary pseudo charset (binary)"))
	<<EnumItem("cp1250", QObject::tr("Windows Central European (cp1250)"))
	<<EnumItem("cp1251", QObject::tr("Windows Cyrillic (cp1251)"))
	<<EnumItem("cp1256", QObject::tr("Windows Arabic (cp1256)"))
	<<EnumItem("cp1257", QObject::tr("Windows Baltic (cp1257)"))
	<<EnumItem("cp850", QObject::tr("DOS West European (cp850)"))
	<<EnumItem("cp852", QObject::tr("DOS Central European (cp852)"))
	<<EnumItem("cp866", QObject::tr("DOS Russian (cp866)"))
	<<EnumItem("cp932", QObject::tr("SJIS for Windows Japanese (cp932)"))
	<<EnumItem("dec8", QObject::tr("DEC West European (dec8)"))
	<<EnumItem("eucjpms",
		QObject::tr("UJIS for Windows Japanese (eucjpms)"))
	<<EnumItem("euckr", QObject::tr("EUC-KR Korean (euckr)"))
	<<EnumItem("gb2312", QObject::tr("GB2312 Simplified Chinese (gb2312)"))
	<<EnumItem("gbk", QObject::tr("GBK Simplified Chinese (gbk)"))
	<<EnumItem("geostd8", QObject::tr("GEOSTD8 Georgian (geostd8)"))
	<<EnumItem("greek", QObject::tr("ISO 8859-7 Greek (greek)"))
	<<EnumItem("hebrew", QObject::tr("ISO 8859-8 Hebrew (hebrew)"))
	<<EnumItem("hp8", QObject::tr("HP West European (hp8)"))
	<<EnumItem("keybcs2",
		QObject::tr("DOS Kamenicky Czech-Slovak (keybcs2)"))
	<<EnumItem("koi8r", QObject::tr("KOI8-R Relcom Russian (koi8r)"))
	<<EnumItem("koi8u", QObject::tr("KOI8-U Ukrainian (koi8u)"))
	<<EnumItem("latin1", QObject::tr("cp1252 West European (latin1)"))
	<<EnumItem("latin2",
		QObject::tr("ISO 8859-2 Central European (latin2)"))
	<<EnumItem("latin5", QObject::tr("ISO 8859-9 Turkish (latin5)"))
	<<EnumItem("latin7", QObject::tr("ISO 8859-13 Baltic (latin7)"))
	<<EnumItem("macce", QObject::tr("Mac Central European (macce)"))
	<<EnumItem("macroman", QObject::tr("Mac West European (macroman)"))
	<<EnumItem("sjis", QObject::tr("Shift-JIS Japanese (sjis)"))
	<<EnumItem("swe7", QObject::tr("7bit Swedish (swe7)"))
	<<EnumItem("tis620", QObject::tr("TIS620 Thai (tis620)"));

	if (type != 1)
		ret<<EnumItem("ucs2", QObject::tr("UCS-2 Unicode (ucs2)"));
	ret<<EnumItem("ujis", QObject::tr("EUC-JP Japanese (ujis)"));
	if (type != 1)
		ret<<EnumItem("utf16", QObject::tr("UTF-16 Unicode (utf16)"));
	ret<<EnumItem("utf16le", QObject::tr("UTF-16LE Unicode (utf16le)"));
	if (type != 1)
		ret<<EnumItem("utf32", QObject::tr("UTF-32 Unicode (utf32)"));
	ret<<EnumItem("utf8", QObject::tr("UTF-8 Unicode (utf8)"))
	<<EnumItem("utf8mb4", QObject::tr("UTF-8 Unicode (utf8mb4)"));

	return (ret);
}


static QStringList
collation_all()
{
	QStringList	ret;

	ret<<"armscii8_bin"<<"armscii8_general_ci"<<"ascii_bin"
	<<"ascii_general_ci"<<"big5_bin"<<"big5_chinese_ci"<<"binary"
	<<"cp1250_bin"<<"cp1250_croatian_ci"<<"cp1250_czech_cs"
	<<"cp1250_general_ci"<<"cp1250_polish_ci"<<"cp1251_bin"
	<<"cp1251_bulgarian_ci"<<"cp1251_general_ci"<<"cp1251_general_cs"
	<<"cp1251_ukrainian_ci"<<"cp1256_bin"<<"cp1256_general_ci"
	<<"cp1257_bin"<<"cp1257_general_ci"<<"cp1257_lithuanian_ci"
	<<"cp850_bin"<<"cp850_general_ci"<<"cp852_bin"<<"cp852_general_ci"
	<<"cp866_bin"<<"cp866_general_ci"<<"cp932_bin"<<"cp932_japanese_ci"
	<<"dec8_bin"<<"dec8_swedish_ci"<<"eucjpms_bin"<<"eucjpms_japanese_ci"
	<<"euckr_bin"<<"euckr_korean_ci"<<"gb2312_bin"<<"gb2312_chinese_ci"
	<<"gbk_bin"<<"gbk_chinese_ci"<<"geostd8_bin"<<"geostd8_general_ci"
	<<"greek_bin"<<"greek_general_ci"<<"hebrew_bin"<<"hebrew_general_ci"
	<<"hp8_bin"<<"hp8_english_ci"<<"keybcs2_bin"<<"keybcs2_general_ci"
	<<"koi8r_bin"<<"koi8r_general_ci"<<"koi8u_bin"<<"koi8u_general_ci"
	<<"latin1_bin"<<"latin1_danish_ci"<<"latin1_general_ci"
	<<"latin1_general_cs"<<"latin1_german1_ci"<<"latin1_german2_ci"
	<<"latin1_spanish_ci"<<"latin1_swedish_ci"<<"latin2_bin"
	<<"latin2_croatian_ci"<<"latin2_czech_cs"<<"latin2_general_ci"
	<<"latin2_hungarian_ci"<<"latin5_bin"<<"latin5_turkish_ci"
	<<"latin7_bin"<<"latin7_estonian_cs"<<"latin7_general_ci"
	<<"latin7_general_cs"<<"macce_bin"<<"macce_general_ci"<<"macroman_bin"
	<<"macroman_general_ci"<<"sjis_bin"<<"sjis_japanese_ci"<<"swe7_bin"
	<<"swe7_swedish_ci"<<"tis620_bin"<<"tis620_thai_ci"<<"ucs2_bin"
	<<"ucs2_croatian_ci"<<"ucs2_czech_ci"<<"ucs2_danish_ci"
	<<"ucs2_esperanto_ci"<<"ucs2_estonian_ci"<<"ucs2_general_ci"
	<<"ucs2_general_mysql500_ci"<<"ucs2_hungarian_ci"<<"ucs2_icelandic_ci"
	<<"ucs2_latvian_ci"<<"ucs2_lithuanian_ci"<<"ucs2_persian_ci"
	<<"ucs2_polish_ci"<<"ucs2_romanian_ci"<<"ucs2_roman_ci"
	<<"ucs2_sinhala_ci"<<"ucs2_slovak_ci"<<"ucs2_slovenian_ci"
	<<"ucs2_spanish2_ci"<<"ucs2_spanish_ci"<<"ucs2_swedish_ci"
	<<"ucs2_turkish_ci"<<"ucs2_unicode_ci"<<"ujis_bin"<<"ujis_japanese_ci"
	<<"utf16le_bin"<<"utf16le_general_ci"<<"utf16_bin"<<"utf16_croatian_ci"
	<<"utf16_czech_ci"<<"utf16_danish_ci"<<"utf16_esperanto_ci"
	<<"utf16_estonian_ci"<<"utf16_general_ci"<<"utf16_hungarian_ci"
	<<"utf16_icelandic_ci"<<"utf16_latvian_ci"<<"utf16_lithuanian_ci"
	<<"utf16_persian_ci"<<"utf16_polish_ci"<<"utf16_romanian_ci"
	<<"utf16_roman_ci"<<"utf16_sinhala_ci"<<"utf16_slovak_ci"
	<<"utf16_slovenian_ci"<<"utf16_spanish2_ci"<<"utf16_spanish_ci"
	<<"utf16_swedish_ci"<<"utf16_turkish_ci"<<"utf16_unicode_ci"
	<<"utf32_bin"<<"utf32_croatian_ci"<<"utf32_czech_ci"<<"utf32_danish_ci"
	<<"utf32_esperanto_ci"<<"utf32_estonian_ci"<<"utf32_general_ci"
	<<"utf32_hungarian_ci"<<"utf32_icelandic_ci"<<"utf32_latvian_ci"
	<<"utf32_lithuanian_ci"<<"utf32_persian_ci"<<"utf32_polish_ci"
	<<"utf32_romanian_ci"<<"utf32_roman_ci"<<"utf32_sinhala_ci"
	<<"utf32_slovak_ci"<<"utf32_slovenian_ci"<<"utf32_spanish2_ci"
	<<"utf32_spanish_ci"<<"utf32_swedish_ci"<<"utf32_turkish_ci"
	<<"utf32_unicode_ci"<<"utf8mb4_bin"<<"utf8mb4_croatian_ci"
	<<"utf8mb4_czech_ci"<<"utf8mb4_danish_ci"<<"utf8mb4_esperanto_ci"
	<<"utf8mb4_estonian_ci"<<"utf8mb4_general_ci"<<"utf8mb4_hungarian_ci"
	<<"utf8mb4_icelandic_ci"<<"utf8mb4_latvian_ci"<<"utf8mb4_lithuanian_ci"
	<<"utf8mb4_persian_ci"<<"utf8mb4_polish_ci"<<"utf8mb4_romanian_ci"
	<<"utf8mb4_roman_ci"<<"utf8mb4_sinhala_ci"<<"utf8mb4_slovak_ci"
	<<"utf8mb4_slovenian_ci"<<"utf8mb4_spanish2_ci"<<"utf8mb4_spanish_ci"
	<<"utf8mb4_swedish_ci"<<"utf8mb4_turkish_ci"<<"utf8mb4_unicode_ci"
	<<"utf8_bin"<<"utf8_croatian_ci"<<"utf8_czech_ci"<<"utf8_danish_ci"
	<<"utf8_esperanto_ci"<<"utf8_estonian_ci"<<"utf8_general_ci"
	<<"utf8_general_mysql500_ci"<<"utf8_hungarian_ci"<<"utf8_icelandic_ci"
	<<"utf8_latvian_ci"<<"utf8_lithuanian_ci"<<"utf8_persian_ci"
	<<"utf8_polish_ci"<<"utf8_romanian_ci"<<"utf8_roman_ci"
	<<"utf8_sinhala_ci"<<"utf8_slovak_ci"<<"utf8_slovenian_ci"
	<<"utf8_spanish2_ci"<<"utf8_spanish_ci"<<"utf8_swedish_ci"
	<<"utf8_turkish_ci"<<"utf8_unicode_ci";

	return (ret);
}


static AbstractVariable *
add_integer(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableInteger(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_enum(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableEnumeration(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_unsigned(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableUnsigned(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_boolean(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableBoolean(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_combo(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableCombo(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_string(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableString(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_set(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableSet(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_real(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableReal(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static AbstractVariable *
add_oswitch(VariableMap *map, const QString &name, const QString &desc)
{
	AbstractVariable	*ret;

	ret = new TunableOptimizerSwitch(name, desc);
	map->insert(ret->name(), ret);

	return (ret);
}


static void
initVariable(VariableMap *map)
{
	union {
		AbstractVariable	*a;
		TunableBoolean		*b;
		TunableCombo		*c;
		TunableEnumeration	*e;
		TunableInteger		*i;
		TunableOptimizerSwitch	*osw;
		TunableReal		*r;
		TunableSet		*st;
		TunableString		*s;
		TunableUnsigned		*u;
	} u;

#include "aria_checkpoint_interval.hpp"
#include "aria_checkpoint_log_activity.hpp"
#include "aria_log_file_size.hpp"
#include "aria_log_purge_type.hpp"
#include "aria_max_sort_file_size.hpp"
#include "aria_page_checksum.hpp"
#include "aria_pagecache_age_threshold.hpp"
#include "aria_pagecache_buffer_size.hpp"
#include "aria_pagecache_division_limit.hpp"
#include "aria_recover.hpp"
#include "aria_repair_threads.hpp"
#include "aria_sort_buffer_size.hpp"
#include "aria_stats_method.hpp"
#include "aria_sync_log_dir.hpp"
#include "auto_increment_increment.hpp"
#include "auto_increment_offset.hpp"
#include "autocommit.hpp"
#include "automatic_sp_privileges.hpp"
#include "big_tables.hpp"

#include "binlog_annotate_row_events.hpp"
#include "binlog_cache_size.hpp"
#include "binlog_checksum.hpp"
#include "binlog_direct_non_transactional_updates.hpp"
#include "binlog_format.hpp"
#include "binlog_stmt_cache_size.hpp"
#include "bulk_insert_buffer_size.hpp"

#include "character_set_client.hpp"
#include "character_set_connection.hpp"
#include "character_set_database.hpp"
#include "character_set_filesystem.hpp"
#include "character_set_results.hpp"
#include "character_set_server.hpp"

#include "collation_connection.hpp"
#include "collation_database.hpp"
#include "collation_server.hpp"
#include "completion_type.hpp"
#include "concurrent_insert.hpp"
#include "connect_timeout.hpp"
#include "debug.hpp"
#include "deadlock_search_depth_long.hpp"
#include "deadlock_search_depth_short.hpp"
#include "deadlock_timeout_long.hpp"
#include "deadlock_timeout_short.hpp"
#include "default_storage_engine.hpp"
#include "default_week_format.hpp"
#include "delay_key_write.hpp"
#include "delayed_insert_limit.hpp"
#include "delayed_insert_timeout.hpp"
#include "delayed_queue_size.hpp"
#include "div_precision_increment.hpp"
#include "engine_condition_pushdown.hpp"
#include "event_scheduler.hpp"
#include "expensive_subquery_limit.hpp"
#include "expire_logs_days.hpp"
#include "extra_max_connections.hpp"
#include "flush.hpp"
#include "flush_time.hpp"
#include "foreign_key_checks.hpp"
#include "ft_boolean_syntax.hpp"
#include "general_log.hpp"
#include "general_log_file.hpp"
#include "group_concat_max_len.hpp"
#include "gtid_domain_id.hpp"
#include "gtid_slave_pos.hpp"
#include "gtid_strict_mode.hpp"

#include "histogram_size.hpp"
#include "histogram_type.hpp"

#include "init_connect.hpp"
#include "init_slave.hpp"

#include "innodb_adaptive_checkpoint.hpp"
#include "innodb_adaptive_flushing.hpp"
#include "innodb_adaptive_flushing_method.hpp"
#include "innodb_adaptive_hash_index.hpp"
#include "innodb_adaptive_max_sleep_delay.hpp"
#include "innodb_analyze_is_persistent.hpp"
#include "innodb_autoextend_increment.hpp"
#include "innodb_buffer_pool_dump_at_shutdown.hpp"
#include "innodb_buffer_pool_dump_now.hpp"
#include "innodb_buffer_pool_filename.hpp"
#include "innodb_buffer_pool_load_abort.hpp"
#include "innodb_buffer_pool_load_now.hpp"
#include "innodb_buffer_pool_restore_at_startup.hpp"
#include "innodb_change_buffer_max_size.hpp"
#include "innodb_change_buffering.hpp"
#include "innodb_checkpoint_age_target.hpp"
#include "innodb_checksum_algorithm.hpp"
#include "innodb_commit_concurrency.hpp"
#include "innodb_concurrency_tickets.hpp"
#include "innodb_corrupt_table_action.hpp"
#include "innodb_dict_size_limit.hpp"
#include "innodb_disable_sort_file_cache.hpp"
#include "innodb_enable_unsafe_group_commit.hpp"
#include "innodb_fake_changes.hpp"
#include "innodb_fast_shutdown.hpp"
#include "innodb_file_format.hpp"
#include "innodb_file_format_max.hpp"
#include "innodb_file_per_table.hpp"
#include "innodb_flush_log_at_trx_commit.hpp"
#include "innodb_flush_neighbors.hpp"
#include "innodb_flush_neighbor_pages.hpp"
#include "innodb_ft_aux_table.hpp"
#include "innodb_ft_enable_diag_print.hpp"
#include "innodb_ft_enable_stopword.hpp"
#include "innodb_ft_num_word_optimize.hpp"
#include "innodb_ft_server_stopword_table.hpp"
#include "innodb_ft_user_stopword_table.hpp"
#include "innodb_ibuf_accel_rate.hpp"
#include "innodb_ibuf_active_contract.hpp"
#include "innodb_import_table_from_xtrabackup.hpp"
#include "innodb_io_capacity.hpp"
#include "innodb_kill_idle_transaction.hpp"
#include "innodb_large_prefix.hpp"
#include "innodb_lazy_drop_table.hpp"
#include "innodb_lock_wait_timeout.hpp"
#include "innodb_locking_fake_changes.hpp"
#include "innodb_locks_unsafe_for_binlog.hpp"
#include "innodb_lru_scan_depth.hpp"
#include "innodb_max_bitmap_file_size.hpp"
#include "innodb_max_changed_pages.hpp"
#include "innodb_max_purge_lag.hpp"
#include "innodb_max_purge_lag_delay.hpp"
#include "innodb_merge_sort_block_size.hpp"
#include "innodb_monitor_disable.hpp"
#include "innodb_monitor_enable.hpp"
#include "innodb_monitor_reset.hpp"
#include "innodb_monitor_reset_all.hpp"
#include "innodb_old_blocks_pct.hpp"
#include "innodb_old_blocks_time.hpp"
#include "innodb_optimize_fulltext_only.hpp"
#include "innodb_print_all_deadlocks.hpp"
#include "innodb_random_read_ahead.hpp"
#include "innodb_read_ahead.hpp"
#include "innodb_read_ahead_threshold.hpp"
#include "innodb_replication_delay.hpp"
#include "innodb_rollback_segments.hpp"
#include "innodb_show_locks_held.hpp"
#include "innodb_show_verbose_locks.hpp"
#include "innodb_spin_wait_delay.hpp"
#include "innodb_stats_auto_update.hpp"
#include "innodb_stats_method.hpp"
#include "innodb_stats_on_metadata.hpp"
#include "innodb_stats_persistent_sample_pages.hpp"
#include "innodb_stats_sample_pages.hpp"
#include "innodb_stats_transient_sample_pages.hpp"
#include "innodb_stats_update_need_lock.hpp"
#include "innodb_strict_mode.hpp"
#include "innodb_support_xa.hpp"
#include "innodb_sync_spin_loops.hpp"
#include "innodb_table_locks.hpp"
#include "innodb_thread_concurrency.hpp"
#include "innodb_thread_sleep_delay.hpp"
#include "innodb_use_global_flush_log_at_trx_commit.hpp"

#include "interactive_timeout.hpp"

#include "join_buffer_size.hpp"
#include "join_buffer_space_limit.hpp"
#include "join_cache_level.hpp"

#include "keep_files_on_create.hpp"
#include "key_buffer_size.hpp"
#include "key_cache_age_threshold.hpp"
#include "key_cache_block_size.hpp"
#include "key_cache_division_limit.hpp"
#include "key_cache_segments.hpp"

#include "lc_messages.hpp"
#include "lc_time_names.hpp"
#include "local_infile.hpp"
#include "lock_wait_timeout.hpp"
#include "log.hpp"
#include "log_bin_trust_function_creators.hpp"
#include "log_output.hpp"
#include "log_queries_not_using_indexes.hpp"
#include "log_slow_filter.hpp"
#include "log_slow_queries.hpp"
#include "log_slow_rate_limit.hpp"
#include "log_slow_verbosity.hpp"
#include "log_warnings.hpp"
#include "long_query_time.hpp"
#include "low_priority_updates.hpp"

#include "master_verify_checksum.hpp"
#include "max_allowed_packet.hpp"
#include "max_binlog_cache_size.hpp"
#include "max_binlog_size.hpp"
#include "max_binlog_stmt_cache_size.hpp"
#include "max_connect_errors.hpp"
#include "max_connections.hpp"
#include "max_delayed_threads.hpp"
#include "max_error_count.hpp"
#include "max_heap_table_size.hpp"
#include "max_insert_delayed_threads.hpp"
#include "max_join_size.hpp"
#include "max_length_for_sort_data.hpp"
#include "max_prepared_stmt_count.hpp"
#include "max_relay_log_size.hpp"
#include "max_seeks_for_key.hpp"
#include "max_sort_length.hpp"
#include "max_sp_recursion_depth.hpp"
#include "max_tmp_tables.hpp"
#include "max_user_connections.hpp"
#include "min_examined_row_limit.hpp"
#include "mrr_buffer_size.hpp"
#include "multi_range_count.hpp"
#include "myisam_data_pointer_size.hpp"
#include "myisam_max_sort_file_size.hpp"
#include "myisam_mmap_size.hpp"
#include "myisam_repair_threads.hpp"
#include "myisam_sort_buffer_size.hpp"
#include "myisam_stats_method.hpp"
#include "myisam_use_mmap.hpp"

#include "net_buffer_length.hpp"
#include "net_read_timeout.hpp"
#include "net_retry_count.hpp"
#include "net_write_timeout.hpp"

#include "old_alter_table.hpp"
#include "old_passwords.hpp"
#include "optimizer_prune_level.hpp"
#include "optimizer_search_depth.hpp"
#include "optimizer_selectivity_sampling_limit.hpp"
#include "optimizer_switch.hpp"
#include "optimizer_use_condition_selectivity.hpp"

#include "preload_buffer_size.hpp"
#include "profiling.hpp"
#include "profiling_history_size.hpp"
#include "progress_report_time.hpp"

#include "query_alloc_block_size.hpp"
#include "query_cache_limit.hpp"
#include "query_cache_min_res_unit.hpp"
#include "query_cache_size.hpp"
#include "query_cache_strip_comments.hpp"
#include "query_cache_type.hpp"
#include "query_cache_wlock_invalidate.hpp"
#include "query_prealloc_size.hpp"

#include "range_alloc_block_size.hpp"
#include "read_buffer_size.hpp"
#include "read_only.hpp"
#include "read_rnd_buffer_size.hpp"
#include "relay_log_purge.hpp"
#include "relay_log_recovery.hpp"
#include "replicate_do_db.hpp"
#include "replicate_do_table.hpp"
#include "replicate_events_marked_for_skip.hpp"
#include "replicate_ignore_db.hpp"
#include "replicate_ignore_table.hpp"
#include "replicate_wild_do_table.hpp"
#include "replicate_wild_ignore_table.hpp"
#include "rowid_merge_buff_size.hpp"

#include "safe_show_database.hpp"
#include "secure_auth.hpp"
#include "server_id.hpp"
#include "slave_compressed_protocol.hpp"
#include "slave_exec_mode.hpp"
#include "slave_max_allowed_packet.hpp"
#include "slave_net_timeout.hpp"
#include "slave_sql_verify_checksum.hpp"
#include "slave_transaction_retries.hpp"
#include "slow_launch_time.hpp"
#include "slow_query_log.hpp"
#include "slow_query_log_file.hpp"
#include "sort_buffer_size.hpp"

#include "sql_auto_is_null.hpp"
#include "sql_big_selects.hpp"
#include "sql_big_tables.hpp"
#include "sql_buffer_result.hpp"
#include "sql_log_bin.hpp"
#include "sql_log_off.hpp"
#include "sql_low_priority_updates.hpp"
#include "sql_max_join_size.hpp"
#include "sql_mode.hpp"
#include "sql_notes.hpp"
#include "sql_quote_show_create.hpp"
#include "sql_safe_updates.hpp"
#include "sql_select_limit.hpp"
#include "sql_slave_skip_counter.hpp"
#include "sql_warnings.hpp"

#include "stored_program_cache.hpp"

#include "sync_binlog.hpp"
#include "sync_frm.hpp"
#include "sync_master_info.hpp"
#include "sync_relay_log.hpp"
#include "sync_relay_log_info.hpp"

#include "table_definition_cache.hpp"
#include "table_lock_wait_timeout.hpp"
#include "table_open_cache.hpp"
#include "thread_cache_size.hpp"
#include "thread_pool_high_priority_connection.hpp"
#include "thread_pool_idle_timeout.hpp"
#include "thread_pool_max_threads.hpp"
#include "thread_pool_max_unused_threads.hpp"
#include "thread_pool_min_threads.hpp"
#include "thread_pool_oversubscribe.hpp"
#include "thread_pool_prio_kickup_timer.hpp"
#include "thread_pool_stall_limit.hpp"
#include "time_zone.hpp"
#include "timed_mutexes.hpp"
#include "tmp_table_size.hpp"
#include "transaction_alloc_block_size.hpp"
#include "transaction_prealloc_size.hpp"
#include "tx_isolation.hpp"
#include "tx_read_only.hpp"

#include "unique_checks.hpp"
#include "updatable_views_with_limit.hpp"
#include "use_stat_tables.hpp"
#include "userstat.hpp"

#include "wait_timeout.hpp"

	/* End of function initVariable() */
}

/* EOF */
