/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: aria_stats_method.hpp,v 1.1 2013/10/01 12:02:32 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "aria_stats_method", QObject::tr(
"Determines how NULLs are treated for Aria index statistics purposes. If set "
"to nulls_equal, all NULL index values are treated as a single group. This is "
"usually fine, but if you have large numbers of NULLs the average group size "
"is slanted higher, and the optimizer may miss using the index for ref "
"accesses when it would be useful. If set to nulls_unequal, the default, the "
"opposite approach is taken, with each NULL forming its own group of one. "
"Conversely, the average group size is slanted lower, and the optimizer may "
"use the index for ref accesses when not suitable. Setting to nulls_ignored "
"ignores NULLs altogether from index group calculations. Statistics need to be "
"recalculated after this method is changed"
));

u.e->setCommandLine(QStringList()<<"--aria-stats-method");
u.e->setConfigLine("aria-stats-method");
u.e->setEnumeration(EnumVector()
	<<EnumItem("nulls_equal", QObject::tr("nulls_equal"))
	<<EnumItem("nulls_unequal", QObject::tr("nulls_unequal"))
	<<EnumItem("nulls_ignored", QObject::tr("nulls_ignored")));
u.e->setValue("nulls_unequal");

/* EOF */
