/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: binlog_direct_non_transactional_updates.hpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "binlog_direct_non_transactional_updates", QObject::tr(
"Replication inconsistencies can occur due when a transaction updates both "
"transactional and non-transactional tables and the updates to the "
"non-transactional tables are visible before being written to the binary log. "
"This is because, to preserve causality, the non-transactional statements are "
"written to the transaction cache, which is only flushed on commit. Setting "
"<b>binlog_direct_non_transactional_updates</b> to 1 (0 is default) will cause "
"non-transactional tables to be written straight to the binary log, rather "
"than the transaction cache. This setting has no effect when row-based binary "
"logging is used, as it requires statement-based logging. See "
"<b>binlog_format</b>. Use with care, and only in situations where no "
"dependencies exist between the non-transactional and transactional tables, "
"for example INSERTing into a non-transactional table based upon the results "
"of a SELECT from a transactional table"
));

u.b->setCommandLine(QStringList()<<"--binlog_direct_non_transactional_updates");
u.b->setConfigLine("binlog-direct-non-transactional-updates");
u.b->setValue(FALSE);

/* EOF */
