/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: binlog_format.hpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "binlog_format", QObject::tr(
"Determines whether replication is row-based, statement-based or mixed. As of "
"MariaDB/MySQL 5.5, statement-based is the default"
));

u.e->setCommandLine(QStringList()<<"--binlog-format");
u.e->setConfigLine("binlog-format");
u.e->setEnumeration(EnumVector()
	<<EnumItem("ROW", QObject::tr("Row"))
	<<EnumItem("STATEMENT", QObject::tr("Statement"))
	<<EnumItem("MIXED", QObject::tr("Mixed")));
u.e->setValue("STATEMENT");

/* EOF */
