/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: binlog_stmt_cache_size.hpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "binlog_stmt_cache_size", QObject::tr(
"If the binary log is active, this variable determines the size in bytes of "
"the cache holding a record of binary log changes outside of a transaction "
"(from MySQL 5.5.3 to 5.5.8 it set the cache size for both transaction and "
"non-transaction caches). The variable binlog_cache_size, determines the cache "
"size for binary log statements inside a transaction. The "
"<b>binlog_stmt_cache_disk_use</b> and <b>binlog_stmt_cache_use</b> server "
"status variables will indicate whether this variable needs to be increased "
"(you want a low ratio of <b>binlog_stmt_cache_disk_use</b> to "
"<b>binlog_stmt_cache_use</b>)"
));

u.u->setCommandLine(QStringList()<<"--binlog_stmt_cache_size");
u.u->setConfigLine("binlog-stmt-cache-size");
u.u->setRange(4096, 18446744073709547520ULL);
u.u->setValue(32768);

/* EOF */
