/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: completion_type.hpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "completion_type", QObject::tr(
"The transaction completion type. If set to <b>NO_CHAIN</b> or <b>0</b> (the "
"default), there is no effect on commits and rollbacks. If set to <b>CHAIN</b> "
"or <b>1</b>, a COMMIT statement is equivalent to <b>COMMIT AND CHAIN</b>, "
"while a ROLLBACK is equivalent to <b>ROLLBACK AND CHAIN</b>, so a new "
"transaction starts straight away with the same isolation level as transaction "
"that's just finished. If set to <b>RELEASE</b> or <b>2</b>, a COMMIT "
"statement is equivalent to <b>COMMIT RELEASE</b>, while a ROLLBACK is "
"equivalent to <b>ROLLBACK RELEASE</b>, so the server will disconnect after "
"the transaction completes. Note that the transaction completion type only "
"applies to explicit commits, not implicit commits"
));

u.e->setCommandLine(QStringList()<<"--completion_type");
u.e->setConfigLine("completion_type");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("NO_CHAIN"))
	<<EnumItem("1", QObject::tr("CHAIN"))
	<<EnumItem("2", QObject::tr("RELEASE"))
);
u.e->setValue("0");

/* EOF */
