/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: concurrent_insert.hpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "concurrent_insert", QObject::tr(
"If set to <b>AUTO</b> or <b>1</b>, the default, MariaDB allows concurrent "
"INSERTs and SELECTs for MyISAM tables with no free blocks in the data. If set "
"to <b>NEVER</b> or <b>0</b>, concurrent inserts are disabled. If set to "
"<b>ALWAYS</b> or </b>2, concurrent inserts are permitted for all MyISAM "
"tables, even those with holes, in which case new rows are added at the end of "
"a table if the table is being used by another thread. If the "
"<b>--skip-new</b> option is used when starting the server, "
"<b>concurrent_insert</b> is set to <b>NEVER</b>"
));

u.e->setCommandLine(QStringList()<<"--concurrent_insert"<<"--skip-new");
u.e->setConfigLine("concurrent_insert");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("NEVER"))
	<<EnumItem("1", QObject::tr("AUTO"))
	<<EnumItem("2", QObject::tr("ALWAYS")));
u.e->setValue("1");

/* EOF */
