/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: delay_key_write.hpp,v 1.1 2013/10/03 13:50:27 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "delay_key_write", QObject::tr(
"Specifies how <b>MyISAM</b> tables handles <b>CREATE TABLE "
"DELAY_KEY_WRITE</b>. If set to <b>ON</b>, the default, any <b>DELAY KEY "
"WRITE</b>s are honored. The key buffer is then flushed only when the table "
"closes, speeding up writes. MyISAM tables should be automatically checked "
"upon startup in this case, and <b>--external</b> locking should not be used, "
"as it can lead to index corruption. If set to <b>OFF</b>, <b>DELAY KEY "
"WRITE</b>s are ignored, while if set to <b>ALL</b>, all new opened tables are "
"treated as if created with <b>DELAY KEY WRITE</b>s enabled"
));

u.e->setCommandLine(QStringList()<<"--delay-key-write");
u.e->setConfigLine("delay_key_write");
u.e->setEnumeration(EnumVector()
	<<EnumItem("ON", QObject::tr("On"))
	<<EnumItem("OFF", QObject::tr("Off"))
	<<EnumItem("ALL", QObject::tr("All")));
u.e->setValue("ON");

/* EOF */
