/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: foreign_key_checks.hpp,v 1.1 2013/10/03 13:50:27 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "foreign_key_checks", QObject::tr(
"If set to <b>1</b>, the default, foreign key constraints for InnoDB tables "
"are checked, while if set to <b>0</b>, they are not checked. 0 is not "
"recommended for normal use, though it can be useful in situations where you "
"know the data is consistent, but want to reload data in a different order "
"from that that specified by parent/child relationships. Setting this variable "
"to <b>1</b> does not retrospectively check for inconsistencies introduced "
"while set to <b>0</b>"
));

u.b->setCommandLine(QStringList()<<"--foreign_key_checks");
u.b->setConfigLine("foreign_key_checks");
u.b->setValue(TRUE);

/* EOF */
