/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: gtid_slave_pos.hpp,v 1.1 2013/10/04 11:59:02 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_string(map, "gtid_slave_pos", QObject::tr(
"This variable is the GTID of the last event group replicated on a slave "
"server, for each replication domain."
"<p>"
"It can be set by the user to change the current replication position. This "
"requires all slave threads to be stopped first. Note that the position is "
"shared among all slave connections when using multi-source replication. To "
"set position for two masters, one using replication domain 1 and another "
"replication domain 2, set a GTID for both domains, for example:"
"<pre>"
"SET GLOBAL gtid_slave_pos = \"1-10-100,2-20-500\";"
"</pre>"
"The variable value is updated whenever an event group is replicated on a "
"slave. The value of the variable is used as the starting point for "
"replication when a slave is configured with "
"<b>CHANGE MASTER TO master_use_gtid=slave_pos</b>."
"<p>"
"If this variable is set to a position that is not more recent than the last "
"GTID in the binary log on the server, a warning will be given. This helps "
"protect the user from setting one value for @@gtid_slave_pos, then being "
"surprised when a slave configured with "
"<b>CHANGE MASTER TO master_use_gtid=current_pos</b> starts replicating at the "
"more recent position found in the binary log. It also helps protect against "
"the case where a server is rolled back to restart replication from an earlier "
"point in time, but the user forgets to also use <b>RESET MASTER</b> to roll "
"back the binary log, thus getting duplicate events in the binlog"
));

/*u.s->setCommandLine(QStringList()<<"--gtid_slave_pos");
u.s->setConfigLine("gtid_slave_pos");*/
/*u.s->setValue(0);*/

/* EOF */
