/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: gtid_strict_mode.hpp,v 1.1 2013/10/04 11:59:02 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "gtid_strict_mode", QObject::tr(
"The GTID strict mode is an optional setting that can be used to help the DBA "
"enforce a strict discipline about keeping binlogs identical across multiple "
"servers replicating using global transaction ID."
"<p>"
"When GTID strict mode is enabled, some additional errors are enabled for "
"situations that could otherwise cause differences between binlogs on "
"different servers in a replication hierarchy:"
"<ol start=\"1\">"
"<li>If a slave server tries to replicate a GTID with a sequence number lower "
"than what is already in the binlog for that replication domain, the SQL "
"thread stops with an error (this indicates an extra transaction in the slave "
"binlog not present on the master)."
"<li>Similarly, an attempt to manually binlog a GTID with a lower sequence "
"number (by setting @@SESSION.gtid_seq_no) is rejected with an error."
"<li>If the slave tries to connect starting at a GTID that is missing in the "
"master's binlog, this is an error in GTID strict mode even if a GTID exists "
"with a higher sequence number (this indicates a GTID on the slave missing on "
"the master). Note that this error is controlled by the setting of GTID strict "
"mode on the connecting slave server."
"</ol>"
"GTID mode is off by default; this is needed to preserve backwards "
"compatibility with existing replication setups (older versions of the server "
"did not enforce any strict mode for binlog order). Global transaction ID is "
"designed to work correctly even when strict mode is not enabled. However, "
"with strict mode enforced, the semantics is simpler and thus easier to "
"understand, because binlog order is always identical across servers and "
"sequence numbers are always strictly increasing within each replication "
"domain. This can also make automated scripting of large replication setups "
"easier to implement correctly."
"<p>"
"When GTID strict mode is enabled, the slave will stop with an error when a "
"problem is encountered. This allows the DBA to become aware of the problem "
"and take corrective actions to avoid similar issues in the future. One way to "
"recover from such an error is to temporarily disable GTID strict mode on the "
"offending slave, to be able to replicate past the problem point (perhaps "
"using <b>START SLAVE UNTIL master_gtid_pos=XXX</b>)"
));

/*u.X->setCommandLine(QStringList()<<"--gtid_strict_mode");
u.X->setConfigLine("gtid_strict_mode");*/
u.b->setValue(FALSE);

/* EOF */
