/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_adaptive_checkpoint.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_adaptive_checkpoint", QObject::tr(
"Controls adaptive checkpointing. InnoDB's fuzzy checkpointing can cause "
"stalls, as many dirty blocks are flushed at once as the checkpoint age nears "
"the maximum. Adaptive checkpointing aims for more consistent flushing, "
"approximately modified age / maximum checkpoint age. Can result in larger "
"transaction log files"
"<ul>"
"<li><b>reflex</b> Similar to innodb_max_dirty_pages_pct flushing but flushes "
"blocks constantly and contiguously based on the oldest modified age. If the "
"age exceeds 1/2 of the maximum age capacity, flushing will be weak "
"contiguous. If the age exceeds 3/4, flushing will be strong. Strength can be "
"adjusted by the variable innodb_io_capacity."
"<li><b>estimate</b> The default, and independent of innodb_io_capacity. If "
"the oldest modified age exceeds 1/2 of the maximum age capacity, blocks will "
"be flushed every second at a rate determined by the number of modified "
"blocks, LSN progress speed and the average age of all modified blocks."
"<li><b>keep_average</b> Attempts to keep the I/O rate constant by using a "
"shorter loop cycle of one tenth of a second. Designed for SSD cards"
"</ul>"
));

u.e->setCommandLine(QStringList()<<"--innodb_adaptive_checkpoint");
u.e->setConfigLine("innodb_adaptive_checkpoint");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("none"))
	<<EnumItem("1", QObject::tr("reflex"))
	<<EnumItem("2", QObject::tr("estimate"))
	<<EnumItem("3", QObject::tr("keep_average")));
u.e->setValue("estimate");

/* EOF */
