/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_adaptive_flushing_method.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_adaptive_flushing_method", QObject::tr(
"Determines the method of flushing dirty blocks from the <b>InnoDB buffer "
"pool</b>. If set to <b>native</b> or <b>0</b>, the original InnoDB method is "
"used. The maximum checkpoint age is determined by the total length of all "
"transaction log files. When the checkpoint age reaches the maximum checkpoint "
"age, blocks are flushed. This can cause lag if there are many updates per "
"second and many blocks with an almost identical age need to be flushed. If set "
"to <b>estimate</b> or <b>1</b>, the default, the oldest modified age will be "
"compared with the maximum age capacity. If it's more than 1/4 of this age, "
"blocks are flushed every second. The number of blocks flushed is determined "
"by the number of modified blocks, the LSN progress speed and the average age "
"of all modified blocks. It's therefore independent of the "
"<b>innodb_io_capacity</b> for the 1-second loop, but not entirely so for the "
"10-second loop. If set to <b>keep_average</b> or <b>2</b>, designed "
"specifically for SSD cards, a shorter loop cycle is used in an attempt to "
"keep the I/O rate constant"
));

u.e->setCommandLine(QStringList()<<"--innodb_adaptive_flushing_method");
u.e->setConfigLine("innodb_adaptive_flushing_method");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("native"))
	<<EnumItem("1", QObject::tr("estimate"))
	<<EnumItem("2", QObject::tr("keep_average"))
);
u.e->setValue("estimate");

/* EOF */
