/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_corrupt_table_action.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_corrupt_table_action", QObject::tr(
"When set to <b>assert</b>, the default, XtraDB will intentionally crash the "
"server when it detects corrupted data in a single-table tablespace, with an "
"assertion failure. When set to <b>warn</b>, it will pass corruption as "
"corrupt table instead of crashing, and disable all further I/O (except for "
"deletion) on the table file. If set to <b>salvage</b>, read access is "
"permitted, but corrupted pages are ignored. <b>innodb_file_per_table</b> "
"must be enabled for this option"
));

u.e->setCommandLine(QStringList()<<"--innodb-corrupt-table-action");
u.e->setConfigLine("innodb_corrupt_table_action");
u.e->setEnumeration(EnumVector()
	<<EnumItem("assert", QObject::tr("assert"))
	<<EnumItem("warn", QObject::tr("warn"))
	<<EnumItem("salvage", QObject::tr("salvage"))
);
u.e->setValue("assert");

/* EOF */
