/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_fake_changes.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "innodb_fake_changes", QObject::tr(
"Enables the fake changes feature. In replication, setting up or restarting a "
"slave can cause a replication reads to perform more slowly, as MariaDB is "
"single-threaded and needs to read the data before it can execute the queries. "
"This can be speeded up by prefetching threads to warm the server, replaying "
"the statements and then rolling back at commit. This however has a overhead "
"from locking rows only then to undo changes at rollback. Fake changes "
"attempts to reduce this overhead by reading the rows for <b>INSERT</b>, "
"<b>UPDATE</b> and <b>DELETE</b> statements but not updating them. The "
"rollback is then very fast with little or nothing to do"
));

u.b->setCommandLine(QStringList()<<"--innodb-fake-changes");
u.b->setConfigLine("innodb_fake_changes");
u.b->setValue(FALSE);

/* EOF */
