/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_fast_shutdown.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_fast_shutdown", QObject::tr(
"The shutdown mode. If set to <b>1</b>, the default, InnoDB performs a fast "
"shutdown, not performing a full purge or an insert buffer merge. If set to "
"<b>0</b>, InnoDB performs a slow shutdown, including full purge and insert "
"buffer merge. If set to <b>2</b>, the logs are flushed and a cold shutdown "
"takes place, similar to a crash. The resulting startup then performs crash "
"recovery. Mode <b>0</b> can be very slow, even taking hours in extreme cases, "
"but is necessary if upgrading to a new major release. Mode <b>2</b> is "
"extremely fast, in cases of emergency, but risks corruption"
));

u.u->setCommandLine(QStringList()<<"--innodb-fast-shutdown");
u.u->setConfigLine("innodb_fast_shutdown");
u.u->setRange(0, 2);
u.u->setValue(1);

/* EOF */
