/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_flush_log_at_trx_commit.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_flush_log_at_trx_commit", QObject::tr(
"If set to <b>1</b>, the default, the log buffer is written to the log file "
"and a flush to disk performed after each transaction. This is required for "
"full ACID compliance. If set to <b>0</b>, nothing is done on commit; rather "
"the log buffer write and flush are performed once a second. This gives better "
"performance, but a server crash can erase the last second of transactions. If "
"set to <b>2</b>, the log buffer is written after each commit, but flushing "
"takes place once a second. Performance is slightly better, but a OS or power "
"outage can cause the last second's transactions to be lost. Set to <b>1</b>, "
"along with sync_binlog=1 for the greatest level of fault tolerance. The value "
"of <b>innodb_use_global_flush_log_at_trx_commit</b> determines whether this "
"variable can be reset with a SET statement or not"
));

u.e->setCommandLine(QStringList()<<"--innodb_flush_log_at_trx_commit");
u.e->setConfigLine("innodb_flush_log_at_trx_commit");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("0"))
	<<EnumItem("1", QObject::tr("1"))
	<<EnumItem("2", QObject::tr("2"))
);
u.e->setValue("1");

/* EOF */
