/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_flush_neighbor_pages.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_flush_neighbor_pages", QObject::tr(
"Determines whether, when dirty pages are flushed to the data file, "
"neighboring pages in the data file are flushed at the same time. If set to "
"<b>none</b>, the feature is disabled. If set to <b>area</b>, the default, the "
"standard InnoDB behavior is used. For each page to be flushed, dirty "
"neighboring pages are flushed too. If there's little head seek delay, such as "
"SSD or large enough write buffer, one of the other two options may be more "
"efficient. If set to <b>cont</b>, for each page to be flushed, neighboring "
"contiguous blocks are flushed at the same time. Being contiguous, a "
"sequential I/O is used, unlike the random I/O used in area"
));

u.e->setCommandLine(QStringList()<<"--innodb-flush-neighbor-pages");
u.e->setConfigLine("innodb_flush_neighbor_pages");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("none"))
	<<EnumItem("1", QObject::tr("area"))
	<<EnumItem("2", QObject::tr("cont"))
);
u.e->setValue("1");

/* EOF */
