/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_flush_neighbors.hpp,v 1.2 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_flush_neighbors", QObject::tr(
"Specifies whether flushing a page from the <b>InnoDB</b> buffer pool also "
"flushes other dirty pages in the same extent."
"<ul>"
"<li>The default value of <b>1</b> flushes contiguous dirty pages in the same "
"extent from the buffer pool."
"<li>A setting of <b>0</b> turns <b>innodb_flush_neighbors</b> off and no "
"other dirty pages are flushed from the buffer pool."
"<li>A setting of <b>2</b> flushes dirty pages in the same extent from the "
"buffer pool."
"</ul>"
"When the table data is stored on a traditional HDD storage device, flushing "
"such neighbor pages in one operation reduces I/O overhead (primarily for disk "
"seek operations) compared to flushing individual pages at different times. "
"For table data stored on SSD, seek time is not a significant factor and you "
"can turn this setting off to spread out the write operations"
));

u.e->setCommandLine(QStringList()<<"--innodb-flush-neighbors");
u.e->setConfigLine("innodb_flush_neighbors");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("Turnes off"))
	<<EnumItem("1", QObject::tr("Flushes contiguous dirty pages in the "
		"same extent from the buffer pool"))
	<<EnumItem("2", QObject::tr("Flushes dirty pages in the same extent "
		"from the buffer pool"))
);
u.e->setValue("1");

/* EOF */
