/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_ft_num_word_optimize.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_ft_num_word_optimize", QObject::tr(
"Number of words to process during each <b>OPTIMIZE TABLE</b> operation on an "
"<b>InnoDB FULLTEXT</b> index. Because a bulk insert or update operation to a "
"table containing a full-text search index could require substantial index "
"maintenance to incorporate all changes, you might do a series of <b>OPTIMIZE "
"TABLE</b> statements, each picking up where the last left off"
));

u.u->setCommandLine(QStringList()<<"--innodb_ft_num_word_optimize");
u.u->setConfigLine("innodb_ft_num_word_optimize");
u.u->setRange(1000, 10000);
u.u->setValue(2000);

/* EOF */
