/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_io_capacity.hpp,v 1.1 2013/10/06 10:06:46 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_io_capacity", QObject::tr(
"Limit on I/O activity for XtraDB/InnoDB background tasks, including merging "
"data from the insert buffer and flushing pages. Should be set to around the "
"number of I/O operations per second that system can handle, based on the type "
"of drive/s being used. You can also set it higher when the server starts to "
"help with the extra workload at that time, and then reduce for normal use. "
"Ideally, opt for a lower setting, as at higher value data is removed from the "
"buffers too quickly, reducing the effectiveness of caching"
));

u.u->setCommandLine(QStringList()<<"--innodb_io_capacity");
u.u->setConfigLine("innodb_io_capacity");
u.u->setRange(100, 18446744073709551615ULL);
u.u->setValue(200);

/* EOF */
