/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_lock_wait_timeout.hpp,v 1.1 2013/10/06 10:06:46 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_lock_wait_timeout", QObject::tr(
"Time in seconds that an InnoDB transaction waits for an InnoDB row lock (not "
"table lock) before giving up with the error ERROR 1205 (HY000): Lock wait "
"timeout exceeded; try restarting transaction. When this occurs, the statement "
"(not transaction) is rolled back. The whole transaction can be rolled back if "
"the <b>innodb_rollback_on_timeout</b> option is used. Increase this for data "
"warehousing applications or where other long-running operations are common, "
"or decrease for OLTP and other highly interactive applications. This setting "
"does not apply to deadlocks, which InnoDB detects immediately, rolling back a "
"deadlocked transaction"
));

u.u->setCommandLine(QStringList()<<"--innodb_lock_wait_timeout");
u.u->setConfigLine("innodb_lock_wait_timeout");
u.u->setRange(1, 1073741824ULL);
u.u->setValue(50);

/* EOF */
