/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_lru_scan_depth.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_lru_scan_depth", QObject::tr(
"A parameter that influences the algorithms and heuristics for the flush "
"operation for the InnoDB buffer pool. Primarily of interest to performance "
"experts tuning I/O-intensive workloads. It specifies, per buffer pool "
"instance, how far down the buffer pool LRU list the page_cleaner thread scans "
"looking for dirty pages to flush. This is a background operation performed "
"once a second. If you have spare I/O capacity under a typical workload, "
"increase the value. If a write-intensive workload saturates your I/O "
"capacity, decrease the value, especially if you have a large buffer pool"
));

u.u->setCommandLine(QStringList()<<"--innodb_lru_scan_depth");
u.u->setConfigLine("innodb_lru_scan_depth");
u.u->setRange(100, 18446744073709551615ULL);
u.u->setValue(1024);

/* EOF */
