/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_max_purge_lag.hpp,v 1.1 2013/10/06 10:06:46 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_max_purge_lag", QObject::tr(
"When purge operations are lagging on a busy server, setting "
"<b>innodb_max_purge_lag</b> can help. By default set to <b>0</b>, no lag, the "
"figure is used to calculate a time lag for each <b>INSERT</b>, <b>UPDATE</b>, "
"and <b>DELETE</b> when the system is lagging. XtraDB/InnoDB keeps a list of "
"transactions with delete-marked index records due to UPDATE and DELETE "
"statements. The length of this list is <b>purge_lag</b>, and the "
"calculation, performed every ten seconds, is as follows: "
"((purge_lag/innodb_max_purge_lag)×10)–5 milliseconds"
));

u.u->setCommandLine(QStringList()<<"--innodb_max_purge_lag");
u.u->setConfigLine("innodb_max_purge_lag");
u.u->setRange(0, 4294967295ULL);
u.u->setValue(0);

/* EOF */
