/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_optimize_fulltext_only.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "innodb_optimize_fulltext_only", QObject::tr(
" Changes the way the <b>OPTIMIZE TABLE</b> statement operates on "
"<b>InnoDB</b> tables. Intended to be enabled temporarily, during maintenance "
"operations for InnoDB tables with <b>FULLTEXT</b> indexes."
"<p>"
"By default, <b>OPTIMIZE TABLE</b> reorganizes the data in the clustered index "
"of the table. When this option is enabled, <b>OPTIMIZE TABLE</b> skips this "
"reorganization of the table data, and instead processes the newly added, "
"deleted, and updated token data for a <b>FULLTEXT</b> index"
));

u.b->setCommandLine(QStringList()<<"--innodb_optimize_fulltext_only");
u.b->setConfigLine("innodb_optimize_fulltext_only");
u.b->setValue(FALSE);

/* EOF */
