/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_read_ahead.hpp,v 1.1 2013/10/06 10:06:46 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "innodb_read_ahead", QObject::tr(
"If set to <b>linear</b>, the default, XtraDB/InnoDB will automatically fetch "
"remaining pages if there are enough within the same extent that can be "
"accessed sequentially. If set to <b>none</b>, read-ahead is disabled. "
"<b>random</b> has been removed and is now ignored, while <b>both</b> sets to "
"both <b>linear</b> and <b>random</b>"
));

u.e->setCommandLine(QStringList()<<"--innodb-read-ahead");
u.e->setConfigLine("innodb_read_ahead");
u.e->setEnumeration(EnumVector()
	<<EnumItem("none", QObject::tr("none"))
	<<EnumItem("random", QObject::tr("random"))
	<<EnumItem("linear", QObject::tr("linear"))
	<<EnumItem("both", QObject::tr("both"))
);
u.e->setValue("linear");

/* EOF */
