/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_stats_on_metadata.hpp,v 1.1 2013/10/06 10:06:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "innodb_stats_on_metadata", QObject::tr(
"If set to <b>1</b>, the default, XtraDB/InnoDB updates statistics when "
"accessing the <b>INFORMATION_SCHEMA.TABLES</b> or "
"<b>INFORMATION_SCHEMA.STATISTICS</b> tables, and when running metadata "
"statements such as <b>SHOW INDEX</b> or <b>SHOW TABLE STATUS</b>. If set to "
"<b>0</b>, statistics are not updated at those times, which can reduce the "
"access time for large schemas, as well as make execution plans more stable"
));

u.b->setCommandLine(QStringList()<<"--innodb_stats_on_metadata");
u.b->setConfigLine("innodb_stats_on_metadata");
u.b->setValue(TRUE);

/* EOF */
