/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_support_xa.hpp,v 1.1 2013/10/06 10:06:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "innodb_support_xa", QObject::tr(
"If set to <b>1</b>, the default, XA transactions are supported. XA support "
"ensures data is written to the binary log in the same order to the actual "
"database, which is critical for replication and disaster recovery, but comes "
"at a small performance cost. If your database is set up to only permit one "
"thread to change data (for example, on a replication slave with only the "
"replication thread writing), it is be safe to turn this option off"
));

u.b->setCommandLine(QStringList()<<"--innodb_support_xa");
u.b->setConfigLine("innodb_support_xa");
u.b->setValue(TRUE);

/* EOF */
