/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_thread_concurrency.hpp,v 1.1 2013/10/06 10:06:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "innodb_thread_concurrency", QObject::tr(
"Once this number of threads is reached (excluding threads waiting for locks), "
"XtraDB/InnoDB will place new threads in a wait state in a first-in, first-out "
"queue for execution, in order to limit the number of threads running "
"concurrently. A setting of <b>0</b>, the default, permits as many threads as "
"necessary. A suggested setting is twice the number of CPU's plus the number "
"of disks"
));

u.u->setCommandLine(QStringList()<<"--innodb_thread_concurrency");
u.u->setConfigLine("innodb_thread_concurrency");
u.u->setRange(0, 1000);
u.u->setValue(0);

/* EOF */
