/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: join_cache_level.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "join_cache_level", QObject::tr(
"Controls which of the eight block-based algorithms can be used for join "
"operations"
"<ul>"
"<li>1 - flat (Block Nested Loop) BNL"
"<li>2 - incremental BNL"
"<li>3 - flat Block Nested Loop Hash (BNLH)"
"<li>4 - incremental BNLH"
"<li>5 - flat Batch Key Access (BKA)"
"<li>6 - incremental BKA"
"<li>7 - flat Batch Key Access Hash (BKAH)"
"<li>8 - incremental BKAH"
"</ul>"
));

u.u->setCommandLine(QStringList()<<"--join_cache_level");
u.u->setConfigLine("join_cache_level");
u.u->setRange(0, 8);
u.u->setValue(2);

/* EOF */
