/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: log_bin_trust_function_creators.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "log_bin_trust_function_creators", QObject::tr(
"By default, <b>CREATE FUNCTION</b> statements are not accepted unless they "
"specify one of <b>DETERMINISTIC</b>, <b>NO SQL</b> or <b>READS SQL DATA</b>. "
"This is because functions that are not one of these may have unexpected "
"consequences on a slave server if they are used in replication. Setting this "
"variable to <b>1</b> relaxes this restriction as well as permitting users to "
"create stored routine and stored functions without the <b>SUPER</b> privilege"
));

u.b->setCommandLine(QStringList()<<"--log_bin_trust_function_creators");
u.b->setConfigLine("log_bin_trust_function_creators");
u.b->setValue(FALSE);

/* EOF */
