/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: log_output.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "log_output", QObject::tr(
"How the output for the general query log and the slow query log is stored. "
"By default written to file (<b>FILE</b>), it can also be stored in the "
"<b>general_log</b> and <b>slow_log</b> tables in the mysql database "
"(<b>TABLE</b>), or not stored at all (<b>NONE</b>). More than one option can "
"be chosen at the same time, with <b>NONE</b> taking precedence if present. "
"Logs will not be written if logging is not enabled"
));

u.e->setCommandLine(QStringList()<<"--log_output");
u.e->setConfigLine("log_output");
u.e->setEnumeration(EnumVector()
	<<EnumItem("NONE", QObject::tr("None"))
	<<EnumItem("FILE", QObject::tr("File"))
	<<EnumItem("TABLE", QObject::tr("Table"))
);
u.e->setValue("FILE");

/* EOF */
