/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: log_slow_filter.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_set(map, "log_slow_filter", QObject::tr(
"Comma-delimited string containing one or more settings for filtering what is "
"logged to the slow query log. If a query matches one of the types listed in "
"the filter, it will be logged."
"<ul>"
"<li>full_scan logs queries that perform full table scans."
"<li>full_join logs queries that perform a join without indexes."
"<li>filesort lgs queries that use a filesort."
"<li>filesort_on_disk logs queries that perform a a filesort on disk."
"<li>tmp_table logs queries that create an implicit temporary table."
"<li>tmp_table_on_disk logs queries that create a temporary table on disk."
"<li>query_cache_miss logs queries that are not found in the query cache"
"</ul>"
));

u.st->setCommandLine(QStringList()<<"--log_slow_filter");
u.st->setConfigLine("log_slow_filter");
u.st->setEnumeration(EnumVector()
	<<EnumItem("admin", QObject::tr("admin"))
	<<EnumItem("filesort", QObject::tr("filesort"))
	<<EnumItem("filesort_on_disk", QObject::tr("filesort_on_disk"))
	<<EnumItem("full_join", QObject::tr("full_join"))
	<<EnumItem("full_scan", QObject::tr("full_scan"))
	<<EnumItem("query_cache", QObject::tr("query_cache"))
	<<EnumItem("query_cache_miss", QObject::tr("query_cache_miss"))
	<<EnumItem("tmp_table", QObject::tr("tmp_table"))
	<<EnumItem("tmp_table_on_disk", QObject::tr("tmp_table_on_disk"))
);
u.st->setValue("admin,filesort,filesort_on_disk,full_join,full_scan,"
	"query_cache,query_cache_miss,tmp_table,tmp_table_on_disk");

/* EOF */
