/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: log_slow_verbosity.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

/* FIXME: I can't change this variable on my test server 10.0.3-MariaDB-log */
u.a = add_set(map, "log_slow_verbosity", QObject::tr(
"Controls information to be added to the slow query log. Options are added in "
"a comma-delimited string."
"<ul>"
"<li>microtime logs queries in microseconds"
"<li>query_plan logs query execution plan information"
"<li>innodb logs XtraDB/InnoDB statistics"
"<li>minimal is equivalent to microtime"
"<li>standard is equivalent to microtime, innodb"
"<li>full is equivalent to all values"
"<li>profiling enables all queries to be profiled (added in XtraDB 5.5.8-20.0)"
"<li>profiling_use_getrusage enables the getrusage function (added in XtraDB "
"5.5.8-20.0)"
"</ul>"
));

u.st->setCommandLine(QStringList()<<"--log_slow_verbosity");
u.st->setConfigLine("log_slow_verbosity");
u.st->setEnumeration(EnumVector()
	<<EnumItem("microtime", QObject::tr("microtime"))
	<<EnumItem("query_plan", QObject::tr("query_plan"))
	<<EnumItem("innodb", QObject::tr("innodb"))
	<<EnumItem("minimal", QObject::tr("minimal"))
	<<EnumItem("standard", QObject::tr("standard"))
	<<EnumItem("full", QObject::tr("full"))
	<<EnumItem("profiling", QObject::tr("profiling "
	"(added in XtraDB 5.5.8-20.0)"))
	<<EnumItem("profiling_use_getrusage",
	QObject::tr("profiling_use_getrusage (added in XtraDB 5.5.8-20.0)"))
);
u.st->setValue("query_plan");

/* EOF */
