/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: log_warnings.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "log_warnings", QObject::tr(
"If set to <b>1</b>, the default, all warnings are logged to the error log, "
"including statements that are not safe for statement-based replication. Slave "
"servers also log status information, including the binary log and relay log "
"co-ordinates where they start replicating from, reconnects after a disconnect "
"and when the slave switches to a new relay-log. If set to <b>0</b>, warnings "
"are not logged. If set to a number greater than 1, aborted connections and "
"access-denied errors are also logged. Specifically, the following are logged:"
"<ul>"
"<li>log_warnings >= 1"
"<ul>"
"<li>Events_schedular info and warnings"
"<li>Access denied errors"
"<li>Connections that was forced to be closed or aborted"
"<li>System signals"
"<li>Wrong usage of --user"
"<li>Failed setrlimit() and mlockall()"
"<li>Changed limits"
"<li>Wrong values of lower_case_table_names and stack_size"
"<li>Wrong values for command line options"
"<li>Start log position and some master information when starting slaves"
"<li>Slave reconnects"
"<li>Killed slaves"
"<li>Error reading relay logs"
"<li>Statements that was unsafe to log as statement based (when "
"BINLOG_FLAG_UNSAFE_STMT_PRINTED is also set)"
"<li>Disabled plugins that one tried to enable or use"
"<li>UDF's files that didn't include the required init functions."
"</ul>"
"<li>log_warnings >= 2"
"<ul>"
"<li>Table handler errors"
"</ul>"
"<li>log_warnings >= 3"
"<ul>"
"<li>All errors and warnings during MyISAM repair and auto recover"
"</ul>"
"</ul>"
));

u.u->setCommandLine(QStringList()<<"--log-warnings"<<"-W");
u.u->setConfigLine("log_warnings");
u.u->setRange(0, 4294967295ULL);
u.u->setValue(1);

/* EOF */
