/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: low_priority_updates.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "low_priority_updates", QObject::tr(
"If set to <b>1</b> (<b>0</b> is the default), for storage engines that use "
"<b>only table-level locking</b> (<b>Aria</b>, <b>MyISAM</b>, <b>MEMORY</b> "
"and <b>MERGE</b>), all <b>INSERT</b>s, <b>UPDATE</b>s, <b>DELETE</b>s and "
"<b>LOCK TABLE WRITE</b>s will wait until there are no more <b>SELECT</b>s or "
"<b>LOCK TABLE READ</b>s pending on the relevant tables. Set this to <b>1</b> "
"if reads are prioritized over writes. Previously named "
"<b>sql_low_priority_updates</b>, which is still a synonym"
));

u.b->setCommandLine(QStringList()<<"--low-priority-updates");
u.b->setConfigLine("low_priority_updates");
u.b->setValue(FALSE);

/* EOF */
