/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: max_binlog_size.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "max_binlog_size", QObject::tr(
"If the binary log exceeds this size after a write, the server rotates it by "
"closing it and opening a new binary log. Single transactions will always be "
"stored in the same binary log, so the server will wait for open transactions "
"to complete before rotating. This figure also applies to the size of relay "
"logs if <b>max_relay_log_size</b> is set to zero"
));

u.u->setCommandLine(QStringList()<<"--max_binlog_size");
u.u->setConfigLine("max_binlog_size");
u.u->setRange(4096, 1073741824ULL);
u.u->setValue(1073741824ULL);

/* EOF */
